/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.processor;

import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.config.api.dsl.ObjectFactoryCommonConfigurator;
import org.mule.runtime.core.api.transformer.AbstractTransformer;

public class TransformerConfigurator
implements ObjectFactoryCommonConfigurator<AbstractTransformer> {
    private Class<?> getReturnType(String returnClass) {
        Class returnType = Object.class;
        if (returnClass != null) {
            try {
                returnType = ClassUtils.getClass((String)returnClass);
            }
            catch (ClassNotFoundException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return returnType;
    }

    @Override
    public void configure(AbstractTransformer transformerInstance, Map<String, Object> parameters) {
        Boolean ignoreBadInput;
        String returnClass = (String)parameters.get("returnClass");
        String mimeType = (String)parameters.get("mimeType");
        String name = (String)parameters.get("name");
        String encoding = (String)parameters.get("encoding");
        Boolean bl = ignoreBadInput = parameters.get("ignoreBadInput") == null ? null : Boolean.valueOf((String)parameters.get("ignoreBadInput"));
        if (returnClass != null || mimeType != null) {
            DataTypeParamsBuilder builder = DataType.builder().type(this.getReturnType(returnClass));
            if (StringUtils.isNotEmpty((CharSequence)mimeType)) {
                builder.mediaType(mimeType);
            }
            transformerInstance.setReturnDataType(builder.charset(encoding).build());
        }
        if (ignoreBadInput != null) {
            transformerInstance.setIgnoreBadInput(ignoreBadInput.booleanValue());
        }
        transformerInstance.setName(name);
    }
}

