/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.ParameterValueVisitor;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.internal.component.config.InternalComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InfrastructureElementModelDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfrastructureElementModelDelegate.class);
    private final Set<String> eeStreamingStrategies = ImmutableSet.of((Object)"repeatable-file-store-stream", (Object)"repeatable-file-store-iterable");

    InfrastructureElementModelDelegate() {
    }

    public void addParameter(final String parameterName, ParameterValue value, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final InternalComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        switch (parameterName) {
            case "reconnection": {
                this.createReconnectionConfig(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "reconnectionStrategy": {
                this.createReconnectionStrategy(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "expirationPolicy": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)value, "expiration-policy", paramDsl.getNamespace());
                return;
            }
            case "streamingStrategy": {
                this.createStreamingStrategy(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "redeliveryPolicy": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)value, "redelivery-policy", paramDsl.getNamespace());
                return;
            }
            case "poolingProfile": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)value, "pooling-profile", paramDsl.getNamespace());
                return;
            }
            case "tlsContext": {
                this.createTlsContext(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
        }
        value.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                parentConfig.withParameter(parameterName, text.getValue());
                parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withValue(text.getValue()).build());
            }
        });
    }

    private void createTlsContext(ParameterValue value, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final InternalComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        value.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                parentConfig.withParameter("tlsContext", text.getValue());
                parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).build());
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                final InternalComponentConfiguration.Builder tlsConfig = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace("tls").name("context").build());
                objectValue.getParameters().forEach((name, value) -> value.accept(new ParameterValueVisitor((String)name){
                    final /* synthetic */ String val$name;
                    {
                        this.val$name = string;
                    }

                    public void visitSimpleValue(ParameterSimpleValue text) {
                        tlsConfig.withParameter(this.val$name, text.getValue());
                    }

                    public void visitObjectValue(ParameterObjectValue objectValue) {
                        if (!"key-store".equals(this.val$name) && !"trust-store".equals(this.val$name)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("Skipping unknown parameter with name [%s] for TLSContext", this.val$name));
                            }
                            return;
                        }
                        InternalComponentConfiguration.Builder nested = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace("tls").name(this.val$name).build());
                        InfrastructureElementModelDelegate.this.cloneParameters(objectValue, nested);
                        tlsConfig.withNestedComponent(nested.build());
                    }
                }));
                InfrastructureElementModelDelegate.this.addParameterElement(parameterModel, paramDsl, parentConfig, parentElement, tlsConfig.build());
            }
        });
    }

    private void createReconnectionConfig(ParameterValue value, ParameterModel parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        final InternalComponentConfiguration.Builder config = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace("mule").name("reconnection").build());
        DslElementModel.Builder<ParameterModel> elementBuilder = DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl);
        ((ParameterObjectValue)value).getParameters().forEach((name, fieldValue) -> fieldValue.accept(new ParameterValueVisitor((String)name, (ParameterValue)fieldValue, parameterModel, paramDsl, elementBuilder){
            final /* synthetic */ String val$name;
            final /* synthetic */ ParameterValue val$fieldValue;
            final /* synthetic */ ParameterModel val$parameterModel;
            final /* synthetic */ DslElementSyntax val$paramDsl;
            final /* synthetic */ DslElementModel.Builder val$elementBuilder;
            {
                this.val$name = string;
                this.val$fieldValue = parameterValue;
                this.val$parameterModel = parameterModel;
                this.val$paramDsl = dslElementSyntax;
                this.val$elementBuilder = builder2;
            }

            public void visitSimpleValue(ParameterSimpleValue text) {
                config.withParameter(this.val$name, text.getValue());
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                if (this.val$name.equals("reconnectionStrategy")) {
                    InfrastructureElementModelDelegate.this.createReconnectionStrategy(this.val$fieldValue, ((ObjectType)this.val$parameterModel.getType()).getFieldByName("reconnectionStrategy").get(), (DslElementSyntax)this.val$paramDsl.getContainedElement("reconnectionStrategy").get(), config, this.val$elementBuilder);
                }
            }
        }));
        ComponentConfiguration result = config.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(elementBuilder.withConfig(result).build());
    }

    private void createReconnectionStrategy(ParameterValue value, Object parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ParameterObjectValue objectValue = (ParameterObjectValue)value;
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)objectValue.getTypeId()) ? 1 : 0) != 0, (String)"Missing declaration of which reconnection to use");
        String elementName = objectValue.getTypeId().equals("reconnect") ? "reconnect" : "reconnect-forever";
        this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, objectValue, elementName, paramDsl.getNamespace());
    }

    private void createStreamingStrategy(ParameterValue value, ParameterModel parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ParameterObjectValue objectValue = (ParameterObjectValue)value;
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)objectValue.getTypeId()) ? 1 : 0) != 0, (String)"Missing declaration of which streaming strategy to use");
        String namespace = this.eeStreamingStrategies.contains(objectValue.getTypeId()) ? "ee" : "mule";
        this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, objectValue, objectValue.getTypeId(), namespace);
    }

    private void cloneDeclarationToElement(Object parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ParameterObjectValue objectValue, String elementName, String customNamespace) {
        InternalComponentConfiguration.Builder config = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace(StringUtils.isBlank((CharSequence)customNamespace) ? "mule" : customNamespace).name(elementName).build());
        this.cloneParameters(objectValue, config);
        this.addParameterElement(parameterModel, paramDsl, parentConfig, parentElement, config.build());
    }

    private void addParameterElement(Object parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ComponentConfiguration result) {
        parentConfig.withNestedComponent(result);
        parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withConfig(result).build());
    }

    private void cloneParameters(ParameterObjectValue objectValue, final InternalComponentConfiguration.Builder redeliveryConfig) {
        objectValue.getParameters().forEach((name, value) -> value.accept(new ParameterValueVisitor((String)name){
            final /* synthetic */ String val$name;
            {
                this.val$name = string;
            }

            public void visitSimpleValue(ParameterSimpleValue text) {
                redeliveryConfig.withParameter(this.val$name, text.getValue());
            }
        }));
    }
}

