/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

final class DataTypeFactoryBean
implements FactoryBean<DataType> {
    public static final String ENCODING = "encoding";
    public static final String MIME_TYPE = "mimeType";
    private Class<?> type;
    private String mimeType;
    private String encoding;

    public static AbstractBeanDefinition buildDataTypeDefinition(String typeName, PropertyValues sourceProperties) {
        BeanDefinitionBuilder dataTypeBuilder = BeanDefinitionBuilder.genericBeanDefinition(DataTypeFactoryBean.class);
        dataTypeBuilder.addConstructorArgValue((Object)typeName);
        dataTypeBuilder.addConstructorArgValue((Object)DataTypeFactoryBean.getMimeType(sourceProperties));
        dataTypeBuilder.addConstructorArgValue((Object)DataTypeFactoryBean.getEncoding(sourceProperties));
        return dataTypeBuilder.getBeanDefinition();
    }

    private static String getMimeType(PropertyValues sourceProperties) {
        return (String)(sourceProperties.contains(MIME_TYPE) ? sourceProperties.getPropertyValue(MIME_TYPE).getValue() : null);
    }

    private static String getEncoding(PropertyValues sourceProperties) {
        return sourceProperties.contains(ENCODING) ? (String)sourceProperties.getPropertyValue(ENCODING).getValue() : null;
    }

    public DataTypeFactoryBean(Class<?> type, String mimeType, String encoding) {
        this.type = type;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public DataType getObject() throws Exception {
        DataTypeParamsBuilder builder = DataType.builder().type(this.type);
        if (StringUtils.isNotEmpty((String)this.mimeType)) {
            builder.mediaType(this.mimeType);
        }
        return builder.charset(this.encoding).build();
    }

    public Class<?> getObjectType() {
        return DataType.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

