/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.generic;

import org.apache.commons.lang.ClassUtils;
import org.mule.runtime.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.runtime.config.spring.parsers.assembly.BeanAssembler;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class ParentDefinitionParser
extends AbstractHierarchicalDefinitionParser {
    public ParentDefinitionParser() {
        this.addBeanFlag("org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_REGISTRATION");
    }

    protected Class getBeanClass(Element element) {
        try {
            return ClassUtils.getClass((String)this.getParentBeanDefinition(element).getBeanClassName());
        }
        catch (Exception e) {
            this.logger.debug("No class for " + element);
            return Object.class;
        }
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.preProcess(element);
        this.setParserContext(parserContext);
        this.setRegistry(parserContext.getRegistry());
        Class beanClass = this.getBeanClass(element);
        Assert.state((beanClass != null ? 1 : 0) != 0, (String)("Class returned from getBeanClass(Element) must not be null, element is: " + element.getNodeName()));
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, beanClass);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().isSingleton() ? "singleton" : "prototype");
        }
        this.doParse(element, parserContext, builder);
        BeanAssembler beanAssembler = this.getBeanAssembler(element, builder);
        beanAssembler.copyBeanToTarget();
        return (AbstractBeanDefinition)beanAssembler.getTarget();
    }

    @Override
    protected void processMetadataAnnotations(Element element, String configFileIdentifier, BeanDefinitionBuilder builder) {
    }

    @Override
    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        if (null == element.getAttributeNode("name")) {
            element.setAttribute("name", this.getParentBeanName(element));
        }
        super.postProcess(context, assembler, element);
    }
}

