/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.config.spring.parsers.specific.DataTypeFactoryBean;
import org.mule.runtime.config.spring.parsers.specific.MessageProcessorWithDataTypeDefinitionParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;

public class TransformerMessageProcessorDefinitionParser
extends MessageProcessorWithDataTypeDefinitionParser {
    private static final String RETURN_CLASS = "returnClass";

    public TransformerMessageProcessorDefinitionParser(Class messageProcessor) {
        super(messageProcessor);
    }

    public TransformerMessageProcessorDefinitionParser() {
    }

    @Override
    protected void removeDataTypeProperties(MutablePropertyValues props) {
        props.removePropertyValue(RETURN_CLASS);
        super.removeDataTypeProperties(props);
    }

    @Override
    protected AbstractBeanDefinition parseDataType(PropertyValues sourceProperties) {
        if (sourceProperties.contains(RETURN_CLASS) || this.isDataTypeConfigured(sourceProperties)) {
            return DataTypeFactoryBean.buildDataTypeDefinition(this.getClassName(sourceProperties), sourceProperties);
        }
        return null;
    }

    private String getClassName(PropertyValues sourceProperties) {
        return sourceProperties.contains(RETURN_CLASS) ? sourceProperties.getPropertyValue(RETURN_CLASS).getValue() : Object.class.getName();
    }
}

