/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.config.spring.parsers.AbstractChildDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.w3c.dom.Element;

public class ObjectFactoryDefinitionParser
extends AbstractChildDefinitionParser {
    protected Class beanClass = null;
    protected String setterMethod = null;

    public ObjectFactoryDefinitionParser(Class beanClass, String setterMethod) {
        this(beanClass);
        this.setterMethod = setterMethod;
    }

    public ObjectFactoryDefinitionParser(Class beanClass) {
        this.beanClass = beanClass;
        this.setAllowClassAttribute(false);
        this.addAlias("class", "objectClassName");
        this.addAlias("ref", "factoryBean");
    }

    @Override
    public String getPropertyName(Element element) {
        if (this.setterMethod != null) {
            return this.setterMethod;
        }
        BeanDefinition parent = this.getParentBeanDefinition(element);
        String setter = (String)parent.getAttribute("objectFactoryPropertyName");
        return setter;
    }

    protected Class getBeanClass(Element element) {
        return this.beanClass;
    }
}

