/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.core.processor.ReferenceProcessor;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class ReferenceBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String REF_ATTRIBUTE = "ref";
    private ImmutableMap<ComponentIdentifier, Consumer<CreateBeanDefinitionRequest>> referenceConsumers = new ImmutableMap.Builder().put((Object)ApplicationModel.PROCESSOR_IDENTIFIER, this.getProcessorConsumer()).put((Object)ApplicationModel.TRANSFORMER_IDENTIFIER, this.getConsumer()).build();

    private Consumer<CreateBeanDefinitionRequest> getProcessorConsumer() {
        return beanDefinitionRequest -> {
            ComponentModel componentModel = beanDefinitionRequest.getComponentModel();
            componentModel.setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ReferenceProcessor.class).addConstructorArgReference(componentModel.getParameters().get(REF_ATTRIBUTE)).getBeanDefinition());
            ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
            beanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
            componentModel.setType(objectTypeVisitor.getType());
        };
    }

    private Consumer<CreateBeanDefinitionRequest> getConsumer() {
        return beanDefinitionRequest -> {
            ComponentModel componentModel = beanDefinitionRequest.getComponentModel();
            componentModel.setBeanReference((BeanReference)new RuntimeBeanReference(componentModel.getParameters().get(REF_ATTRIBUTE)));
            ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
            beanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit((TypeDefinitionVisitor)objectTypeVisitor);
            componentModel.setType(objectTypeVisitor.getType());
        };
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (this.referenceConsumers.containsKey((Object)componentModel.getIdentifier())) {
            ((Consumer)this.referenceConsumers.get((Object)componentModel.getIdentifier())).accept(createBeanDefinitionRequest);
            return true;
        }
        return false;
    }
}

