/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.cli.CommandLine;
import org.mule.runtime.module.reboot.internal.BootstrapConfigurationException;
import org.mule.runtime.module.reboot.internal.BootstrapConfigurer;
import org.mule.runtime.module.reboot.internal.MuleContainerFactory;
import org.mule.runtime.module.reboot.internal.MuleContainerWrapper;

public abstract class AbstractMuleContainerWrapper
implements MuleContainerWrapper {
    private final Collection<BootstrapConfigurer> bootstrapConfigurers = new ArrayList<BootstrapConfigurer>();

    @Override
    public void addBootstrapConfigurer(BootstrapConfigurer bootstrapConfigurer) {
        this.bootstrapConfigurers.add(bootstrapConfigurer);
    }

    @Override
    public void configureAndStart(MuleContainerFactory muleContainerFactory, CommandLine commandLine) {
        if (this.configure()) {
            System.out.println("Starting the Mule Container...");
            this.start(muleContainerFactory, commandLine.getArgs());
        }
    }

    private boolean configure() {
        try {
            for (BootstrapConfigurer bootstrapConfigurer : this.bootstrapConfigurers) {
                if (bootstrapConfigurer.configure()) continue;
                this.stop(0);
                return false;
            }
            return true;
        }
        catch (BootstrapConfigurationException e) {
            this.haltAndCatchFire(e.getExitCode(), e.getMessage());
            return false;
        }
    }

    protected Future<Boolean> getAllConfigurersReady() {
        return CompletableFuture.supplyAsync(this::waitAllConfigurersReady);
    }

    private boolean waitAllConfigurersReady() {
        try {
            for (BootstrapConfigurer bootstrapConfigurer : this.bootstrapConfigurers) {
                bootstrapConfigurer.await();
            }
            return true;
        }
        catch (BootstrapConfigurationException e) {
            this.haltAndCatchFire(e.getExitCode(), e.getMessage());
            return false;
        }
    }

    @Override
    public void dispose() {
        for (BootstrapConfigurer bootstrapConfigurer : this.bootstrapConfigurers) {
            bootstrapConfigurer.dispose();
        }
    }

    protected abstract void start(MuleContainerFactory var1, String[] var2);
}

