/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataResolvingException;

public final class DefaultMetadataCache
implements MetadataCache {
    private final Map<Serializable, Serializable> cache = new ConcurrentHashMap<Serializable, Serializable>();

    public void put(Serializable key, Serializable value) {
        this.cache.put(key, value);
    }

    public void putAll(Map<? extends Serializable, ? extends Serializable> values) {
        this.cache.putAll(values);
    }

    public <T extends Serializable> Optional<T> get(Serializable key) {
        return Optional.ofNullable(this.cache.get(key));
    }

    public <T extends Serializable> T computeIfAbsent(Serializable key, MetadataCache.MetadataCacheValueResolver mappingFunction) throws MetadataResolvingException, ConnectionException {
        Serializable value = this.cache.get(key);
        if (value == null && (value = mappingFunction.compute(key)) != null) {
            this.cache.putIfAbsent(key, value);
        }
        return (T)value;
    }

    public Map<Serializable, Serializable> asMap() {
        return ImmutableMap.copyOf(this.cache);
    }
}

