/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.internal.cache.ComponentBasedIdHelper;

public class AstConfigurationMetadataCacheIdGenerator
implements ConfigurationMetadataCacheIdGenerator {
    private final Map<String, LazyValue<MetadataCacheId>> configInternals = new HashMap<String, LazyValue<MetadataCacheId>>();
    private final Map<String, LazyValue<MetadataCacheId>> configIds = new HashMap<String, LazyValue<MetadataCacheId>>();

    @Override
    public Optional<MetadataCacheId> getConfigMetadataCacheId(String configName, boolean justProviders) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            return Optional.empty();
        }
        Map<String, LazyValue<MetadataCacheId>> ids = justProviders ? this.configInternals : this.configIds;
        MetadataCacheId result = ids.containsKey(configName) ? (MetadataCacheId)ids.get(configName).get() : null;
        return Optional.ofNullable(result);
    }

    @Override
    public void addConfigurations(List<ComponentAst> configAsts) {
        this.configInternals.clear();
        this.configIds.clear();
        configAsts.forEach(config -> {
            String configLocation = config.getLocation().getRootContainerName();
            this.configInternals.put(configLocation, (LazyValue<MetadataCacheId>)new LazyValue(() -> this.resolveInternalComponents((ComponentAst)config)));
            this.configIds.put(configLocation, (LazyValue<MetadataCacheId>)new LazyValue(() -> this.doResolve((ComponentAst)config)));
        });
    }

    private MetadataCacheId doResolve(ComponentAst elementModel) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        keyParts.add(ComponentBasedIdHelper.resolveComponentIdentifierMetadataCacheId(elementModel));
        elementModel.getModel(ComponentModel.class).map(model -> ComponentBasedIdHelper.resolveMetadataKeyParts(elementModel, model, true, configName -> this.getConfigMetadataCacheId((String)configName, false))).orElseGet(() -> Optional.ofNullable(this.resolveInternalComponents(elementModel))).ifPresent(keyParts::add);
        return new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel));
    }

    private MetadataCacheId resolveInternalComponents(ComponentAst elementModel) {
        List<String> parameterNamesRequiredForMetadata = ComponentBasedIdHelper.parameterNamesRequiredForMetadataCacheId(elementModel);
        List<MetadataCacheId> parts = Stream.concat(elementModel.directChildrenStream().map(this::doResolve), elementModel.getModel(ParameterizedModel.class).map(pmz -> elementModel.getParameters().stream().filter(p -> p.getValue().getValue().isPresent()).filter(p -> parameterNamesRequiredForMetadata.contains(p.getModel().getName())).map(p -> ComponentBasedIdHelper.resolveKeyFromSimpleValue(elementModel, p, configName -> this.getConfigMetadataCacheId((String)configName, false)))).orElse(Stream.empty())).collect(Collectors.toList());
        if (parts.isEmpty()) {
            return null;
        }
        return new MetadataCacheId(parts, (String)ComponentBasedIdHelper.getModelNameAst(elementModel).orElse(null));
    }
}

