/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.config.dsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.PrivateOperationsModelProperty;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.config.dsl.XmlSdkConfigurationProviderFactory;
import org.mule.runtime.extension.internal.factories.ModuleOperationMessageProcessorFactoryBean;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;

public class XmlExtensionBuildingDefinitionProvider
implements ExtensionBuildingDefinitionProvider {
    private static final String MESSAGE_PROCESSORS = "messageProcessors";
    private final List<ComponentBuildingDefinition> definitions = new LinkedList<ComponentBuildingDefinition>();
    private Set<ExtensionModel> extensions = Collections.emptySet();

    public void init() {
        Preconditions.checkState((this.extensions != null ? 1 : 0) != 0, (String)"extensions cannot be null");
        this.extensions.stream().forEach(this::registerExtensionParsers);
    }

    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        return this.definitions;
    }

    private void registerExtensionParsers(final ExtensionModel extensionModel) {
        XmlDslModel xmlDslModel = extensionModel.getXmlDslModel();
        final ComponentBuildingDefinition.Builder definitionBuilder = new ComponentBuildingDefinition.Builder().withNamespace(xmlDslModel.getPrefix());
        final ComponentBuildingDefinition.Builder tnsDefinitionBuilder = new ComponentBuildingDefinition.Builder().withNamespace("tns");
        final DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)DslResolvingContext.getDefault(this.extensions));
        if (extensionModel.getModelProperty(CustomBuildingDefinitionProviderModelProperty.class).isPresent()) {
            return;
        }
        if (extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()) {
            extensionModel.getModelProperty(PrivateOperationsModelProperty.class).ifPresent(privateOperations -> privateOperations.getOperationNames().forEach(privateOperationName -> privateOperations.getOperationModel(privateOperationName).ifPresent(opModel -> this.addModuleOperationChainParser(tnsDefinitionBuilder, dslSyntaxResolver, extensionModel, (OperationModel)opModel))));
            final AtomicBoolean configPresent = new AtomicBoolean(false);
            new IdempotentExtensionWalker(){

                public void onConfiguration(ConfigurationModel configurationModel) {
                    configPresent.set(true);
                    List paramsDefinitions = XmlExtensionBuildingDefinitionProvider.this.processParametersDefinitions(definitionBuilder, dslSyntaxResolver, (ParameterizedModel)configurationModel);
                    XmlExtensionBuildingDefinitionProvider.this.definitions.add(definitionBuilder.withIdentifier(dslSyntaxResolver.resolve((NamedObject)configurationModel).getElementName()).withTypeDefinition(TypeDefinition.fromType(ConfigurationProvider.class)).withObjectFactoryType(XmlSdkConfigurationProviderFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)extensionModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)configurationModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(Registry.class).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])paramsDefinitions.toArray(new KeyAttributeDefinitionPair[paramsDefinitions.size()])).build()).build());
                }

                public void onOperation(OperationModel model) {
                    XmlExtensionBuildingDefinitionProvider.this.addModuleOperationChainParser(definitionBuilder, dslSyntaxResolver, extensionModel, model);
                    XmlExtensionBuildingDefinitionProvider.this.addModuleOperationChainParser(tnsDefinitionBuilder, dslSyntaxResolver, extensionModel, model);
                }
            }.walk(extensionModel);
            if (!configPresent.get()) {
                this.definitions.add(definitionBuilder.withIdentifier("_defaultGlobalElements").withTypeDefinition(TypeDefinition.fromType(ConfigurationProvider.class)).withObjectFactoryType(XmlSdkConfigurationProviderFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)extensionModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(null).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(Registry.class).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromFixedValue(null).build()).build());
            }
        }
    }

    private void addModuleOperationChainParser(ComponentBuildingDefinition.Builder baseDefinition, DslSyntaxResolver dslSyntaxResolver, ExtensionModel extensionModel, OperationModel operationModel) {
        List<KeyAttributeDefinitionPair> paramsDefinitions = this.processParametersDefinitions(baseDefinition, dslSyntaxResolver, (ParameterizedModel)operationModel);
        this.definitions.add(baseDefinition.withIdentifier(dslSyntaxResolver.resolve((NamedObject)operationModel).getElementName()).withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(ModuleOperationMessageProcessorFactoryBean.class).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])paramsDefinitions.toArray(new KeyAttributeDefinitionPair[paramsDefinitions.size()])).build()).withSetterParameterDefinition("extensionModel", AttributeDefinition.Builder.fromFixedValue((Object)extensionModel).build()).withSetterParameterDefinition("operationModel", AttributeDefinition.Builder.fromFixedValue((Object)operationModel).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
    }

    private List<KeyAttributeDefinitionPair> processParametersDefinitions(ComponentBuildingDefinition.Builder baseDefinition, DslSyntaxResolver dslSyntaxResolver, ParameterizedModel operationModel) {
        ArrayList<KeyAttributeDefinitionPair> paramsDefinitions = new ArrayList<KeyAttributeDefinitionPair>();
        List allParameterModels = operationModel.getAllParameterModels();
        for (ParameterModel parameterModel : allParameterModels) {
            if (parameterModel.getDslConfiguration().allowsInlineDefinition()) {
                this.processInlineParameterDefinition(baseDefinition, dslSyntaxResolver, paramsDefinitions, parameterModel);
                continue;
            }
            paramsDefinitions.add(KeyAttributeDefinitionPair.newBuilder().withKey(parameterModel.getName()).withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)dslSyntaxResolver.resolve(parameterModel).getAttributeName()).withDefaultValue(parameterModel.getDefaultValue()).build()).build());
        }
        return paramsDefinitions;
    }

    private void processInlineParameterDefinition(ComponentBuildingDefinition.Builder baseDefinition, DslSyntaxResolver dslSyntaxResolver, List<KeyAttributeDefinitionPair> paramsDefinitions, ParameterModel parameterModel) {
        Class type = this.isBehaviour(parameterModel) ? JavaTypeUtils.getType((MetadataType)parameterModel.getType()) : String.class;
        paramsDefinitions.add(KeyAttributeDefinitionPair.newBuilder().withKey(parameterModel.getName()).withAttributeDefinition(AttributeDefinition.Builder.fromChildConfiguration((Class)type).withIdentifier(dslSyntaxResolver.resolve(parameterModel).getElementName()).withDefaultValue(parameterModel.getDefaultValue()).build()).build());
        this.definitions.add(baseDefinition.withIdentifier(dslSyntaxResolver.resolve(parameterModel).getElementName()).withTypeDefinition(TypeDefinition.fromType((Class)type)).build());
        if (this.isBehaviour(parameterModel)) {
            paramsDefinitions.add(KeyAttributeDefinitionPair.newBuilder().withKey(parameterModel.getName()).withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter((String)dslSyntaxResolver.resolve(parameterModel).getAttributeName()).withDefaultValue(parameterModel.getDefaultValue()).build()).build());
            this.registerComponentBuildingDefinitionType(baseDefinition, parameterModel, dslSyntaxResolver.resolve(parameterModel));
        }
    }

    private boolean isBehaviour(ParameterModel parameterModel) {
        return parameterModel.getRole() == ParameterRole.BEHAVIOUR;
    }

    private void registerComponentBuildingDefinitionType(final ComponentBuildingDefinition.Builder baseDefinition, ParameterModel parameterModel, final DslElementSyntax parameterDsl) {
        parameterModel.getType().accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                final Optional itemDsl = parameterDsl.getGeneric(arrayType.getType());
                if (parameterDsl.supportsChildDeclaration() && itemDsl.isPresent()) {
                    arrayType.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                        protected void visitBasicType(MetadataType metadataType) {
                            XmlExtensionBuildingDefinitionProvider.this.definitions.add(baseDefinition.withIdentifier(((DslElementSyntax)itemDsl.get()).getElementName()).withNamespace(((DslElementSyntax)itemDsl.get()).getPrefix()).withTypeDefinition(TypeDefinition.fromType(ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).orElse(Object.class))).build());
                        }
                    });
                }
            }
        });
    }

    public void setExtensionModels(Set<ExtensionModel> extensionModels) {
        this.extensions = extensionModels;
    }
}

