/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.execution.FlowProcessingTemplate;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;

public final class ExtensionsFlowProcessingTemplate
extends FlowProcessingTemplate {
    private SourceResultAdapter sourceMessage;
    private final SourceCompletionHandler completionHandler;

    ExtensionsFlowProcessingTemplate(SourceResultAdapter sourceMessage, Processor messageProcessor, List<NotificationFunction> notificationFunctions, SourceCompletionHandler completionHandler) {
        super(messageProcessor, notificationFunctions);
        this.sourceMessage = sourceMessage;
        this.completionHandler = completionHandler;
    }

    public CheckedFunction<CoreEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return this.completionHandler::createResponseParameters;
    }

    public CheckedFunction<CoreEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return this.completionHandler::createFailureResponseParameters;
    }

    public SourceResultAdapter getSourceMessage() {
        return this.sourceMessage;
    }

    public void sendResponseToClient(CoreEvent response, Map<String, Object> parameters, CompletableCallback<Void> callback) {
        this.completionHandler.onCompletion(response, parameters, callback);
    }

    public void sendFailureResponseToClient(MessagingException exception, Map<String, Object> parameters, CompletableCallback<Void> callback) {
        this.completionHandler.onFailure(exception, parameters, callback);
    }

    public void afterPhaseExecution(Either<MessagingException, CoreEvent> either) {
        try {
            this.completionHandler.onTerminate(either);
        }
        catch (Exception e) {
            throw Exceptions.propagateWrappingFatal((Throwable)e);
        }
        finally {
            this.sourceMessage = null;
        }
    }
}

