/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.result;

import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.result.AbstractReturnDelegate;

public final class TargetReturnDelegate
extends AbstractReturnDelegate {
    private final ExpressionManager expressionManager;
    private final String target;
    private final CompiledExpression targetValue;
    private final StreamingManager streamingManager;

    public TargetReturnDelegate(String target, String targetValue, ComponentModel componentModel, ExpressionManager expressionManager, MuleContext muleContext, StreamingManager streamingManager) {
        super(componentModel, muleContext);
        this.expressionManager = expressionManager;
        this.target = target;
        this.targetValue = expressionManager.compile(targetValue, BindingContextUtils.getTargetBindingContext((Message)Message.of((Object)"")));
        this.streamingManager = streamingManager;
    }

    @Override
    public CoreEvent asReturnValue(Object value, ExecutionContextAdapter operationContext) {
        try (ExpressionManagerSession session = this.expressionManager.openSession(BindingContextUtils.getTargetBindingContext((Message)this.toMessage(value, operationContext)));){
            CoreEvent event = operationContext.getEvent();
            TypedValue typedValue = session.evaluate(this.targetValue);
            TypedValue managedTypedValue = StreamingUtils.updateTypedValueForStreaming((TypedValue)typedValue, (CoreEvent)event, (StreamingManager)this.streamingManager);
            CoreEvent coreEvent = CoreEvent.builder((CoreEvent)event).securityContext(operationContext.getSecurityContext()).addVariable(this.target, managedTypedValue).build();
            return coreEvent;
        }
    }
}

