/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;

public abstract class AbstractSourceResultArgumentResolver<T>
implements ArgumentResolver<T> {
    private ArgumentResolver<Error> errorArgumentResolver;
    private static final Set<String> GENERATE_ERRORS = Stream.of(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE, Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE).map(ComponentIdentifier::getName).collect(Collectors.toSet());

    public AbstractSourceResultArgumentResolver(ArgumentResolver<Error> errorArgumentResolver) {
        this.errorArgumentResolver = errorArgumentResolver;
    }

    @Override
    public T resolve(ExecutionContext executionContext) {
        Error error = this.errorArgumentResolver.resolve(executionContext);
        if (error == null) {
            return this.resolveSuccess(executionContext);
        }
        String errorIdentifier = error.getErrorType().getIdentifier();
        return this.isErrorGeneratingErrorResponse(errorIdentifier) ? this.resolveInvocationError(executionContext) : this.resolveResponseError(executionContext);
    }

    protected abstract T resolveSuccess(ExecutionContext var1);

    protected abstract T resolveInvocationError(ExecutionContext var1);

    protected abstract T resolveResponseError(ExecutionContext var1);

    private boolean isErrorGeneratingErrorResponse(String identifier) {
        return GENERATE_ERRORS.contains(identifier);
    }
}

