/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.sdk.api.runtime.route.Chain;
import org.mule.sdk.api.runtime.route.Route;

public class JavaModelLoaderUtils {
    public static boolean isScope(MethodElement methodElement) {
        return methodElement.getParameters().stream().anyMatch(JavaModelLoaderUtils::isProcessorChain);
    }

    public static boolean isRouter(MethodElement methodElement) {
        return !JavaModelLoaderUtils.getRoutes(methodElement).isEmpty();
    }

    public static List<ExtensionParameter> getRoutes(MethodElement methodElement) {
        return methodElement.getParameters().stream().filter(JavaModelLoaderUtils::isRoute).collect(Collectors.toList());
    }

    public static boolean isNonBlocking(MethodElement method) {
        return !JavaModelLoaderUtils.getCompletionCallbackParameters(method).isEmpty();
    }

    public static List<ExtensionParameter> getCompletionCallbackParameters(MethodElement method) {
        return method.getParameters().stream().filter(p -> p.getType().isAssignableTo(CompletionCallback.class) || p.getType().isAssignableTo(org.mule.sdk.api.runtime.process.CompletionCallback.class)).collect(Collectors.toList());
    }

    public static boolean isProcessorChain(ExtensionParameter parameter) {
        return parameter.getType().isAssignableTo(org.mule.runtime.extension.api.runtime.route.Chain.class) || parameter.getType().isAssignableTo(Chain.class);
    }

    public static boolean isInputStream(MetadataType type) {
        return JavaModelLoaderUtils.isAssignableFrom(type, InputStream.class);
    }

    private static boolean isAssignableFrom(MetadataType metadataType, Class<?> type) {
        return ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).map(clazz -> type.isAssignableFrom((Class<?>)clazz)).orElse(false);
    }

    public static boolean isRoute(ExtensionParameter parameter) {
        return parameter.getType().isAssignableTo(org.mule.runtime.extension.api.runtime.route.Route.class) || parameter.getType().isAssignableTo(Route.class);
    }

    public static boolean emitsResponse(SourceElement sourceElement) {
        return sourceElement.isAnnotatedWith(EmitsResponse.class) || sourceElement.isAnnotatedWith(org.mule.sdk.api.annotation.source.EmitsResponse.class);
    }
}

