/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.NestedRouteModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.route.JavaChainParsingUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.route.ExecutionOccurrence;
import org.mule.sdk.api.runtime.route.Route;

public class JavaNestedRouteModelParser
implements NestedRouteModelParser {
    private final ExtensionParameter route;
    private final ExtensionLoadingContext loadingContext;
    private final List<ModelProperty> additionalModelProperties = new LinkedList<ModelProperty>();
    private final boolean sdkApiDefined;

    public JavaNestedRouteModelParser(ExtensionParameter route, ExtensionLoadingContext loadingContext) {
        this.route = route;
        this.loadingContext = loadingContext;
        Class clazz = route.getType().getDeclaringClass().orElse(null);
        if (clazz != null) {
            this.additionalModelProperties.add(new ImplementingTypeModelProperty(clazz));
            this.sdkApiDefined = Route.class.isAssignableFrom(clazz);
        } else {
            this.sdkApiDefined = false;
        }
    }

    @Override
    public String getName() {
        return this.route.getAlias();
    }

    @Override
    public String getDescription() {
        return this.route.getDescription();
    }

    @Override
    public int getMinOccurs() {
        return this.route.isRequired() ? 1 : 0;
    }

    @Override
    public Optional<Integer> getMaxOccurs() {
        return Optional.of(1);
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        List<FieldElement> parameters = this.route.getType().getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.Parameter.class, Parameter.class);
        return JavaExtensionModelParserUtils.getParameterGroupParsers(parameters, ParameterDeclarationContext.forRoute(this.getName(), this.loadingContext));
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return this.additionalModelProperties;
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.route);
    }

    @Override
    public List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory factory) {
        return JavaStereotypeModelParserUtils.getAllowedStereotypes(this.route, this.route.getType(), factory);
    }

    @Override
    public ChainExecutionOccurrence getExecutionOccurrence() {
        return JavaChainParsingUtils.parseChainExecutionOccurrence(this.route.getValueFromAnnotation(ExecutionOccurrence.class));
    }

    @Override
    public Set<String> getSemanticTerms() {
        return new LinkedHashSet<String>();
    }

    @Override
    public boolean isSdkApiDefined() {
        return this.sdkApiDefined;
    }
}

