/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class JavaScopeModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        final DslSyntaxResolver dsl = DslSyntaxResolver.getDefault((ExtensionModel)model, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        new ExtensionWalker(){

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                JavaScopeModelValidator.this.validateScope((ComponentModel)model, problemsReporter, dsl);
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                JavaScopeModelValidator.this.validateScope((ComponentModel)model, problemsReporter, dsl);
            }
        }.walk(model);
    }

    private void validateScope(ComponentModel model, ProblemsReporter problemsReporter, DslSyntaxResolver dsl) {
        if (ExtensionModelUtils.isScope((ComponentModel)model)) {
            JavaScopeModelValidator.validateNoInlineParameters((ParameterizedModel)model, "Scope", problemsReporter, dsl);
        }
    }

    public static void validateNoInlineParameters(ParameterizedModel model, String kind, ProblemsReporter problemsReporter, DslSyntaxResolver dsl) {
        model.getParameterGroupModels().stream().forEach(group -> {
            if (group.isShowInDsl()) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("Invalid parameter group [%s] found in operation [%s], inline groups are not allowed in %s", group.getName(), model.getName(), kind)));
            }
            group.getParameterModels().stream().filter(parameter -> !parameter.getModelProperty(InfrastructureParameterModelProperty.class).isPresent()).forEach(parameter -> {
                if (dsl.resolve(parameter).supportsChildDeclaration()) {
                    problemsReporter.addError(new Problem((NamedObject)model, String.format("Invalid parameter [%s] found in group [%s] of operation [%s], parameters that allow inline declaration are not allowed in %s. Use attribute declaration only for all the parameters.", parameter.getName(), group.getName(), model.getName(), kind)));
                }
            });
        });
    }
}

