/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Map;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;

public abstract class ComponentMessageProcessorBuilder<M extends ComponentModel, P extends ExtensionComponent> {
    protected final ExtensionModel extensionModel;
    protected final M operationModel;
    protected final ReflectionCache reflectionCache;
    protected final MuleContext muleContext;
    protected final ExpressionManager expressionManager;
    protected final ComponentTracerFactory<CoreEvent> componentTracerFactory;
    protected Registry registry;
    protected final ExtensionConnectionSupplier extensionConnectionSupplier;
    protected ConfigurationProvider configurationProvider;
    protected long terminationTimeout;
    protected Map<String, ?> parameters;
    protected String target;
    protected String targetValue;
    protected CursorProviderFactory cursorProviderFactory;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected MessageProcessorChain nestedChain;
    protected ClassLoader classLoader;

    public ComponentMessageProcessorBuilder(ExtensionModel extensionModel, M operationModel, ReflectionCache reflectionCache, ExpressionManager expressionManager, MuleContext muleContext, Registry registry) {
        Preconditions.checkArgument((extensionModel != null ? 1 : 0) != 0, (String)"ExtensionModel cannot be null");
        Preconditions.checkArgument((operationModel != null ? 1 : 0) != 0, (String)"OperationModel cannot be null");
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
        this.muleContext = muleContext;
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.reflectionCache = reflectionCache;
        this.registry = registry;
        this.extensionConnectionSupplier = (ExtensionConnectionSupplier)registry.lookupByType(ExtensionConnectionSupplier.class).get();
        this.componentTracerFactory = (ComponentTracerFactory)registry.lookupByType(ComponentTracerFactory.class).get();
        this.expressionManager = expressionManager;
        this.terminationTimeout = muleContext.getConfiguration().getShutdownTimeout();
    }

    public P build() {
        return (P)((Object)((ExtensionComponent)((Object)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> {
            try {
                ExtensionManager extensionManager = this.muleContext.getExtensionManager();
                ResolverSet operationArguments = this.getArgumentsResolverSet();
                P processor = this.createMessageProcessor(extensionManager, operationArguments);
                this.muleContext.getInjector().inject(processor);
                return processor;
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }))));
    }

    protected abstract P createMessageProcessor(ExtensionManager var1, ResolverSet var2);

    protected ResolverSet getArgumentsResolverSet() throws ConfigurationException {
        ResolverSet parametersResolverSet = ParametersResolver.fromValues(this.parameters, this.muleContext, this.reflectionCache, this.expressionManager, this.operationModel.getName()).getParametersAsResolverSet((ParameterizedModel)this.operationModel, this.muleContext);
        ResolverSet childsResolverSet = ParametersResolver.fromValues(this.parameters, this.muleContext, this.reflectionCache, this.expressionManager, this.operationModel.getName()).getNestedComponentsAsResolverSet((ComponentModel)this.operationModel);
        return parametersResolverSet.merge(childsResolverSet);
    }

    public ComponentMessageProcessorBuilder<M, P> setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setParameters(Map<String, ?> parameters) {
        this.parameters = SmallMap.copy(parameters);
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setTarget(String target) {
        this.target = target;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setTargetValue(String targetValue) {
        this.targetValue = targetValue;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setNestedChain(MessageProcessorChain nestedChain) {
        this.nestedChain = nestedChain;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ComponentMessageProcessorBuilder<M, P> setTerminationTimeout(long terminationTimeout) {
        this.terminationTimeout = terminationTimeout;
        return this;
    }

    protected ValueResolver<ConfigurationProvider> getConfigurationProviderResolver() {
        return this.configurationProvider != null ? new StaticValueResolver<ConfigurationProvider>(this.configurationProvider) : this.getConfigurationProviderResolver(this.parameters.get("config-ref"));
    }

    private ValueResolver<ConfigurationProvider> getConfigurationProviderResolver(Object configRefParameter) {
        if (configRefParameter instanceof ValueResolver) {
            return (ValueResolver)configRefParameter;
        }
        if (configRefParameter instanceof ConfigurationProvider) {
            return new StaticValueResolver<ConfigurationProvider>((ConfigurationProvider)configRefParameter);
        }
        return null;
    }
}

