/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataProviderFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.data.sample.SampleDataProvider;

public final class SampleDataProviderFactoryModelProperty
implements ModelProperty {
    private final Field connectionField;
    private final Field configField;
    private final Class<? extends SampleDataProvider> sampleDataProvider;
    private final List<InjectableParameterInfo> injectableParameters;

    private SampleDataProviderFactoryModelProperty(Class<? extends SampleDataProvider> sampleDataProvider, List<InjectableParameterInfo> injectableParameters, Field connectionField, Field configField) {
        Objects.requireNonNull(sampleDataProvider, "SampleDataProvider Class parameter can't be null");
        Objects.requireNonNull(injectableParameters, "injectableParameters parameter can't be null");
        this.sampleDataProvider = sampleDataProvider;
        this.injectableParameters = injectableParameters;
        this.connectionField = connectionField;
        this.configField = configField;
    }

    public static SampleDataProviderFactoryModelPropertyBuilder builder(Class<? extends SampleDataProvider> sampleDataProvider) {
        return new SampleDataProviderFactoryModelPropertyBuilder(sampleDataProvider);
    }

    public String getName() {
        return "SampleDataProviderFactory";
    }

    public boolean isPublic() {
        return false;
    }

    public <T, A> Class<? extends SampleDataProvider<T, A>> getSampleDataProviderClass() {
        return this.sampleDataProvider;
    }

    public List<String> getRequiredParameters() {
        return this.injectableParameters.stream().map(InjectableParameterInfo::getParameterName).collect(Collectors.toList());
    }

    public List<InjectableParameterInfo> getInjectableParameters() {
        return this.injectableParameters;
    }

    public boolean usesConnection() {
        return this.connectionField != null;
    }

    public boolean usesConfig() {
        return this.configField != null;
    }

    public SampleDataProviderFactory createFactory(ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ReflectionCache reflectionCache, MuleContext muleContext, ParameterizedModel parameterizedModel) {
        return new SampleDataProviderFactory(this, parameterValueResolver, connectionSupplier, configurationSupplier, this.connectionField, this.configField, reflectionCache, muleContext, parameterizedModel);
    }

    public static class SampleDataProviderFactoryModelPropertyBuilder {
        private final Class<? extends SampleDataProvider> sampleDataProvider;
        private final List<InjectableParameterInfo> injectableParameters;
        private Field connectionField;
        private Field configField;

        public SampleDataProviderFactoryModelPropertyBuilder(Class<? extends SampleDataProvider> sampleDataProvider) {
            this.sampleDataProvider = sampleDataProvider;
            this.injectableParameters = new ArrayList<InjectableParameterInfo>();
        }

        public SampleDataProviderFactoryModelPropertyBuilder withInjectableParameter(String name, MetadataType metadataType, boolean isRequired) {
            return this.withInjectableParameter(name, metadataType, isRequired, name);
        }

        public SampleDataProviderFactoryModelPropertyBuilder withInjectableParameter(String name, MetadataType metadataType, boolean isRequired, String extractionExpression) {
            this.injectableParameters.add(new InjectableParameterInfo(name, metadataType, isRequired, extractionExpression));
            return this;
        }

        public void withConnection(Field connectionField) {
            this.connectionField = connectionField;
        }

        public void withConfig(Field configField) {
            this.configField = configField;
        }

        public SampleDataProviderFactoryModelProperty build() {
            return new SampleDataProviderFactoryModelProperty(this.sampleDataProvider, this.injectableParameters, this.connectionField, this.configField);
        }
    }
}

