/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.List;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.StackableTypesModelPropertyResolver;

public final class ParameterDeclarationContext {
    private static final StackableTypesModelPropertyResolver STACKABLE_TYPES_RESOLVER = StackableTypesModelPropertyResolver.newInstance();
    private final String componentName;
    private final String componentType;
    private final boolean keyResolverAvailable;

    public static ParameterDeclarationContext forConfig(String configName) {
        return new ParameterDeclarationContext(configName, "Configuration");
    }

    public static ParameterDeclarationContext forOperation(String operationName) {
        return new ParameterDeclarationContext(operationName, "Operation");
    }

    public static ParameterDeclarationContext forOperation(String operationName, boolean keyResolverAvailable) {
        return new ParameterDeclarationContext(operationName, "Operation", keyResolverAvailable);
    }

    public static ParameterDeclarationContext forSource(String sourceName) {
        return new ParameterDeclarationContext(sourceName, "Source");
    }

    public static ParameterDeclarationContext forSource(String sourceName, boolean keyResolverAvailable) {
        return new ParameterDeclarationContext(sourceName, "Source", keyResolverAvailable);
    }

    public static ParameterDeclarationContext forConnectionProvider(String connectionProviderName) {
        return new ParameterDeclarationContext(connectionProviderName, "Connection Provider");
    }

    public static ParameterDeclarationContext forFunction(String functionName) {
        return new ParameterDeclarationContext(functionName, "Function");
    }

    public static ParameterDeclarationContext forRoute(String routeName) {
        return new ParameterDeclarationContext(routeName, "Route");
    }

    public ParameterDeclarationContext(String componentName, String componentType) {
        this(componentName, componentType, false);
    }

    public ParameterDeclarationContext(String componentName, String componentType, boolean keyResolverAvailable) {
        this.componentName = componentName;
        this.componentType = componentType;
        this.keyResolverAvailable = keyResolverAvailable;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public boolean isKeyResolverAvailable() {
        return this.keyResolverAvailable;
    }

    public List<ModelProperty> resolveStackableTypes(ExtensionParameter extensionParameter) {
        return STACKABLE_TYPES_RESOLVER.resolveStackableProperties(extensionParameter, this);
    }
}

