/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.api.annotation.Experimental;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.metadata.ComponentMetadataConfigurer;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.internal.DefaultMetadataResolverFactory;
import org.mule.runtime.metadata.internal.NullMetadataResolverFactory;
import org.mule.runtime.metadata.internal.NullMetadataResolverSupplier;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.metadata.chain.AllOfRoutesOutputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.OneOfRoutesOutputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.PassThroughChainOutputTypeResolver;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;

@MinMuleVersion(value="4.7.0")
@Experimental
public final class DefaultComponentMetadataConfigurer
implements ComponentMetadataConfigurer {
    private TypeKeysResolver keysResolver = NullMetadataResolverSupplier.NULL_METADATA_RESOLVER;
    private String keyParameterName;
    private MetadataType keyParameterType;
    private boolean hasPartialKeyResolver = false;
    private OutputTypeResolver outputTypeResolver = NullMetadataResolverSupplier.NULL_METADATA_RESOLVER;
    private AttributesTypeResolver attributesTypeResolver = NullMetadataResolverSupplier.NULL_METADATA_RESOLVER;
    private final Map<String, Supplier<? extends InputTypeResolver>> inputResolvers = new HashMap<String, Supplier<? extends InputTypeResolver>>();
    private final Map<String, String> inputResolverNames = new HashMap<String, String>();
    private String firstSeenInputResolverCategory = null;
    private ChainInputTypeResolver chainInputTypeResolver;
    private final Map<String, ChainInputTypeResolver> routesChainInputTypesResolvers = new HashMap<String, ChainInputTypeResolver>();
    private boolean connected = false;

    public <T extends ParameterizedDeclaration> void configureNullMetadata(ParameterizedDeclaration<T> declaration) {
        declaration.addModelProperty((ModelProperty)new MetadataResolverFactoryModelProperty(() -> new NullMetadataResolverFactory()));
    }

    public <T extends ParameterizedDeclarer, D extends ParameterizedDeclaration> void configureNullMetadata(ParameterizedDeclarer<T, D> declarer) {
        this.configureNullMetadata((ParameterizedDeclaration)declarer.getDeclaration());
    }

    public DefaultComponentMetadataConfigurer setOutputTypeResolver(OutputTypeResolver outputTypeResolver) {
        Preconditions.checkArgument((outputTypeResolver != null ? 1 : 0) != 0, (String)"outputTypeResolver cannot be null");
        this.outputTypeResolver = outputTypeResolver;
        return this;
    }

    public DefaultComponentMetadataConfigurer setAttributesTypeResolver(AttributesTypeResolver attributesTypeResolver) {
        Preconditions.checkArgument((attributesTypeResolver != null ? 1 : 0) != 0, (String)"attributesTypeResolver cannot be null");
        this.attributesTypeResolver = attributesTypeResolver;
        return this;
    }

    public DefaultComponentMetadataConfigurer setKeysResolver(TypeKeysResolver keysResolver, String keyParameterName, MetadataType keyParameterType, boolean isPartialKeyResolver) {
        Preconditions.checkArgument((keysResolver != null ? 1 : 0) != 0, (String)"keysResolver cannot be null");
        Preconditions.checkArgument((!StringUtils.isBlank((String)keyParameterName) ? 1 : 0) != 0, (String)"keyParameterName cannot be blank");
        Preconditions.checkArgument((keyParameterType != null ? 1 : 0) != 0, (String)"keyParameterType cannot be null");
        this.keysResolver = keysResolver;
        this.keyParameterName = keyParameterName;
        this.keyParameterType = keyParameterType;
        this.hasPartialKeyResolver = isPartialKeyResolver;
        return this;
    }

    public DefaultComponentMetadataConfigurer setChainInputTypeResolver(ChainInputTypeResolver chainInputTypeResolver) {
        this.chainInputTypeResolver = chainInputTypeResolver;
        return this;
    }

    public DefaultComponentMetadataConfigurer addInputResolver(String parameterName, InputTypeResolver resolver) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)parameterName) ? 1 : 0) != 0, (String)"parameterName cannot be blank");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        this.inputResolvers.put(parameterName, () -> resolver);
        this.inputResolverNames.put(parameterName, resolver.getResolverName());
        if (this.firstSeenInputResolverCategory == null) {
            this.firstSeenInputResolverCategory = resolver.getCategoryName();
        }
        return this;
    }

    public DefaultComponentMetadataConfigurer addInputResolvers(Map<String, InputTypeResolver> resolvers) {
        Preconditions.checkArgument((resolvers != null ? 1 : 0) != 0, (String)"resolvers cannot be null");
        resolvers.forEach(this::addInputResolver);
        return this;
    }

    public DefaultComponentMetadataConfigurer addRouteChainInputResolver(String routeName, ChainInputTypeResolver resolver) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)routeName) ? 1 : 0) != 0, (String)"routeName cannot be blank");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        this.routesChainInputTypesResolvers.put(routeName, resolver);
        return this;
    }

    public DefaultComponentMetadataConfigurer addRoutesChainInputResolvers(Map<String, ChainInputTypeResolver> resolvers) {
        Preconditions.checkArgument((resolvers != null ? 1 : 0) != 0, (String)"resolvers cannot be null");
        resolvers.forEach(this::addRouteChainInputResolver);
        return this;
    }

    public DefaultComponentMetadataConfigurer setConnected(boolean connected) {
        this.connected = connected;
        return this;
    }

    public DefaultComponentMetadataConfigurer asOneOfRouter() {
        this.setOutputTypeResolver(OneOfRoutesOutputTypeResolver.INSTANCE);
        this.setAttributesTypeResolver(OneOfRoutesOutputTypeResolver.INSTANCE);
        return this;
    }

    public DefaultComponentMetadataConfigurer asPassthroughScope() {
        this.setOutputTypeResolver(PassThroughChainOutputTypeResolver.INSTANCE);
        this.setAttributesTypeResolver(PassThroughChainOutputTypeResolver.INSTANCE);
        return this;
    }

    public DefaultComponentMetadataConfigurer asAllOfRouter() {
        this.setOutputTypeResolver(AllOfRoutesOutputTypeResolver.INSTANCE);
        return this;
    }

    public <T extends ParameterizedDeclarer, D extends ParameterizedDeclaration> void configure(ParameterizedDeclarer<T, D> declarer) {
        this.configure((ParameterizedDeclaration)declarer.getDeclaration());
    }

    public <T extends ComponentDeclaration> void configure(ParameterizedDeclaration<T> declaration) {
        declaration.addModelProperty((ModelProperty)this.buildFactoryModelProperty());
        this.buildResolverInformationModelProperty(declaration).ifPresent(arg_0 -> declaration.addModelProperty(arg_0));
        if (this.keysResolver != NullMetadataResolverSupplier.NULL_METADATA_RESOLVER) {
            declaration.addModelProperty((ModelProperty)new MetadataKeyIdModelProperty(this.keyParameterType, this.keyParameterName, ModelLoaderUtils.getCategoryName(this.keysResolver, this.firstSeenInputResolverCategory, this.outputTypeResolver)));
        }
    }

    private MetadataResolverFactoryModelProperty buildFactoryModelProperty() {
        return new MetadataResolverFactoryModelProperty(() -> new DefaultMetadataResolverFactory(() -> this.keysResolver, this.copy(this.inputResolvers), () -> this.outputTypeResolver, () -> this.attributesTypeResolver, Optional.ofNullable(this.chainInputTypeResolver), this.copy(this.routesChainInputTypesResolvers)));
    }

    private Optional<TypeResolversInformationModelProperty> buildResolverInformationModelProperty(ParameterizedDeclaration declaration) {
        String categoryName = ModelLoaderUtils.getCategoryName(this.keysResolver, this.firstSeenInputResolverCategory, this.outputTypeResolver);
        if (StringUtils.isBlank((String)categoryName)) {
            return Optional.empty();
        }
        return Optional.of(new TypeResolversInformationModelProperty(categoryName, this.copy(this.inputResolverNames), this.outputTypeResolver.getResolverName(), this.attributesTypeResolver.getResolverName(), this.keysResolver.getResolverName(), this.connected, this.connected, this.hasPartialKeyResolver));
    }

    private <K, V> Map<K, V> copy(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }
}

