/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.internal.ExtensionDevelopmentFramework;
import org.mule.runtime.module.extension.internal.loader.ModelLoaderDelegateUtils;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.AllowedStereotypesModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OperationModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationModelLoaderDelegate.class);
    private final Map<OperationModelParser, OperationDeclarer> operationDeclarers = new HashMap<OperationModelParser, OperationDeclarer>();

    OperationModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, ExtensionDevelopmentFramework extensionDevelopmentFramework, HasOperationDeclarer ownerDeclarer, List<OperationModelParser> operations) {
        for (OperationModelParser parser : operations) {
            boolean extensionLevelOperation;
            if (parser.isIgnored()) continue;
            boolean requiresConfig = ModelLoaderDelegateUtils.requiresConfig(extensionDevelopmentFramework, parser);
            HasOperationDeclarer actualDeclarer = requiresConfig ? ownerDeclarer : extensionDeclarer;
            boolean bl = extensionLevelOperation = actualDeclarer == extensionDeclarer;
            if (extensionLevelOperation && parser.isAutoPaging()) {
                throw new IllegalOperationModelDefinitionException(String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", parser.getName()));
            }
            if (extensionLevelOperation && requiresConfig) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", parser.getName()));
            }
            if (this.operationDeclarers.containsKey(parser)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(parser));
                continue;
            }
            this.operationDeclarers.put(parser, this.createOperationDeclarer(parser, extensionDeclarer, actualDeclarer));
        }
    }

    private OperationDeclarer createOperationDeclarer(OperationModelParser parser, ExtensionDeclarer extensionDeclarer, HasOperationDeclarer actualDeclarer) {
        OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(parser.getName()).describedAs(parser.getDescription())).supportsStreaming(parser.supportsStreaming())).transactional(parser.isTransactional())).requiresConnection(parser.isConnected())).blocking(parser.isBlocking()).withVisibility(parser.getComponentVisibility());
        parser.getExecutorModelProperty().ifPresent(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
        parser.getOutputType().applyOn(operation.withOutput());
        parser.getAttributesOutputType().applyOn(operation.withOutputAttributes());
        parser.getMediaTypeModelProperty().ifPresent(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
        Optional<OutputResolverModelParser> outputResolverModelParser = parser.getOutputResolverModelParser();
        Optional<AttributesResolverModelParser> attributesResolverModelParser = parser.getAttributesResolverModelParser();
        List<InputResolverModelParser> inputResolverModelParsers = parser.getInputResolverModelParsers();
        Optional<MetadataKeyModelParser> keyIdResolverModelParser = parser.getMetadataKeyModelParser();
        ModelLoaderUtils.declareMetadataModelProperties((ParameterizedDeclaration)operation.getDeclaration(), outputResolverModelParser, attributesResolverModelParser, inputResolverModelParsers, keyIdResolverModelParser, parser.isConnected(), parser.getScopeChainInputTypeResolverModelParser(), parser.getRoutesChainInputTypesResolverModelParser());
        parser.getDeprecationModel().ifPresent(arg_0 -> ((OperationDeclarer)operation).withDeprecation(arg_0));
        parser.getDisplayModel().ifPresent(d -> ((OperationDeclaration)operation.getDeclaration()).setDisplayModel(d));
        parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> {
            operation.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
            LOGGER.debug(resolvedMMV.getReason());
        });
        this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)operation, parser.getParameterGroupModelParsers());
        ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)operation.getDeclaration(), parser);
        parser.getExecutionType().ifPresent(arg_0 -> ((OperationDeclarer)operation).withExecutionType(arg_0));
        parser.getAdditionalModelProperties().forEach(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
        parser.getExceptionHandlerModelProperty().ifPresent(arg_0 -> ((OperationDeclarer)operation).withModelProperty(arg_0));
        this.declareChains(parser, operation);
        this.loader.registerOutputTypes((ExecutableComponentDeclaration)operation.getDeclaration());
        ModelLoaderDelegateUtils.declareErrorModels((ComponentDeclarer)operation, parser, extensionDeclarer, this.loader.createErrorModelFactory());
        this.getStereotypeModelLoaderDelegate().addStereotypes(parser, operation, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultOperationStereotype(parser.getName())));
        NotificationModelParserUtils.declareEmittedNotifications(parser, (ExecutableComponentDeclarer)operation, this.loader::getNotificationModel);
        return operation;
    }

    private void declareChains(OperationModelParser parser, OperationDeclarer operation) {
        if (parser.isScope()) {
            parser.getNestedChainParser().ifPresent(chain -> {
                NestedChainDeclarer chainDeclarer = ((NestedChainDeclarer)operation.withChain(chain.getName()).describedAs(chain.getDescription())).setRequired(chain.isRequired()).setExecutionOccurrence(chain.getExecutionOccurrence());
                ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)chainDeclarer.getDeclaration(), chain);
                this.getStereotypeModelLoaderDelegate().addAllowedStereotypes((AllowedStereotypesModelParser)chain, (NestedComponentDeclarer)chainDeclarer);
            });
        } else if (parser.isRouter()) {
            parser.getNestedRouteParsers().forEach(route -> {
                NestedRouteDeclarer routeDeclarer = operation.withRoute(route.getName()).describedAs(route.getDescription()).withMinOccurs(route.getMinOccurs()).withMaxOccurs((Integer)route.getMaxOccurs().orElse(null));
                NestedChainDeclarer chain = routeDeclarer.withChain().setExecutionOccurrence(route.getExecutionOccurrence());
                this.getStereotypeModelLoaderDelegate().addAllowedStereotypes((AllowedStereotypesModelParser)route, (NestedComponentDeclarer)chain);
                route.getAdditionalModelProperties().forEach(arg_0 -> ((NestedRouteDeclarer)routeDeclarer).withModelProperty(arg_0));
                this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)routeDeclarer, route.getParameterGroupModelParsers());
            });
        }
    }
}

