/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackedTypesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ResolverUtils {
    private ResolverUtils() {
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(ObjectFieldType field, MuleContext muleContext) {
        Optional defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)field);
        Preconditions.checkArgument((boolean)defaultValue.isPresent(), (String)("No default value available for field :" + field.getKey().getName()));
        return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue.get(), field.getValue(), muleContext);
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(MetadataType fieldType, String defaultValue, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(defaultValue, fieldType, muleContext);
    }

    public static ValueResolver<?> getExpressionBasedValueResolver(String expression, MetadataType metadataType, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), Optional.empty(), metadataType, muleContext);
    }

    static ValueResolver<?> getExpressionBasedValueResolver(String expression, ParameterModel operationModel, MuleContext muleContext) {
        MetadataType metadataType = operationModel.getType();
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), StackedTypesModelProperty.getStackedTypesModelProperty(operationModel.getModelProperties()), metadataType, muleContext);
    }

    static ValueResolver<?> getDefaultValueResolver(ParameterModel parameter, MuleContext muleContext) {
        Object defaultValue = parameter.getDefaultValue();
        if (defaultValue instanceof String) {
            return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue, parameter, muleContext);
        }
        if (defaultValue != null) {
            return new StaticValueResolver<Object>(defaultValue);
        }
        return null;
    }

    public static <T> T resolveRecursively(ValueResolver<T> valueResolver, ValueResolvingContext resolvingContext) throws MuleException {
        T resolve = valueResolver.resolve(resolvingContext);
        if (resolve instanceof ValueResolver) {
            resolve = ResolverUtils.resolveRecursively((ValueResolver)resolve, resolvingContext);
        }
        return resolve;
    }

    public static <T> T resolveValue(ValueResolver<T> resolver, ValueResolvingContext context) throws MuleException {
        T value = ResolverUtils.resolveRecursively(resolver, context);
        if (context == null || context.resolveCursors()) {
            return (T)ResolverUtils.resolveCursor(value);
        }
        return value;
    }

    public static Object resolveCursor(Object value) {
        return ResolverUtils.resolveCursor(value, UnaryOperator.identity());
    }

    public static Object resolveCursor(Object value, UnaryOperator valueMapper) {
        if (value instanceof CursorProvider) {
            return valueMapper.apply(((CursorProvider)value).openCursor());
        }
        return ResolverUtils.resolveTypedValue(value, valueMapper);
    }

    public static Object resolveTypedValue(Object value, UnaryOperator valueMapper) {
        if (value instanceof TypedValue) {
            return ResolverUtils.resolveCursor((TypedValue)value, valueMapper);
        }
        return valueMapper.apply(value);
    }

    public static Object mapTypeValue(Object value, UnaryOperator valueMapper) {
        if (value instanceof TypedValue) {
            return ResolverUtils.typedValue((TypedValue)value, valueMapper, ((TypedValue)value).getValue());
        }
        return valueMapper.apply(value);
    }

    public static Object resolveCursor(TypedValue<?> typedValue) {
        return ResolverUtils.resolveCursor(typedValue, UnaryOperator.identity());
    }

    public static Object resolveCursor(TypedValue<?> typedValue, UnaryOperator valueMapper) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorProvider) {
            Cursor cursor = ((CursorProvider)objectValue).openCursor();
            return ResolverUtils.typedValue(typedValue, valueMapper, cursor);
        }
        Object mappedValue = valueMapper.apply(objectValue);
        if (mappedValue == objectValue) {
            return typedValue;
        }
        return new TypedValue(mappedValue, typedValue.getDataType(), typedValue.getByteLength());
    }

    private static Object typedValue(TypedValue<?> typedValue, UnaryOperator valueMapper, Object value) {
        return new TypedValue(valueMapper.apply(value), DataType.builder().type(value != null ? value.getClass() : Object.class).mediaType(typedValue.getDataType().getMediaType()).build(), typedValue.getByteLength());
    }

    private static ValueResolver<?> getExpressionBasedValueResolver(String expression, BooleanSupplier isTypedValue, BooleanSupplier isParameterResolver, Optional<StackedTypesModelProperty> stackedTypesModelProperty, MetadataType type, MuleContext muleContext) {
        try {
            Initialisable resolver;
            if (stackedTypesModelProperty.isPresent()) {
                resolver = stackedTypesModelProperty.get().getValueResolverFactory().getExpressionBasedValueResolver(expression, JavaTypeUtils.getType((MetadataType)type));
            } else if (isTypedValue.getAsBoolean()) {
                ExpressionTypedValueValueResolver valueResolver = new ExpressionTypedValueValueResolver(expression, JavaTypeUtils.getType((MetadataType)type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                resolver = valueResolver;
            } else if (isParameterResolver.getAsBoolean()) {
                ExpressionBasedParameterResolverValueResolver valueResolver = new ExpressionBasedParameterResolverValueResolver(expression, JavaTypeUtils.getType((MetadataType)type), IntrospectionUtils.toDataType(type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                resolver = valueResolver;
            } else if (muleContext.getExpressionManager().isExpression(expression)) {
                TypeSafeExpressionValueResolver valueResolver = new TypeSafeExpressionValueResolver(expression, JavaTypeUtils.getType((MetadataType)type), IntrospectionUtils.toDataType(type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                resolver = valueResolver;
            } else {
                TypeSafeValueResolverWrapper typeSafeValueResolverWrapper = new TypeSafeValueResolverWrapper(new StaticValueResolver<String>(expression), JavaTypeUtils.getType((MetadataType)type));
                typeSafeValueResolverWrapper.setTransformationService(muleContext.getTransformationService());
                resolver = typeSafeValueResolverWrapper;
            }
            LifecycleUtils.initialiseIfNeeded((Object)resolver, (MuleContext)muleContext);
            return resolver;
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

