/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.executor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodExecutorGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodExecutorGenerator.class);
    private static final String TARGET_INSTANCE_FIELD_NAME = "__targetInstance";
    private final Map<String, Class<MethodExecutor>> executorClasses = new ConcurrentHashMap<String, Class<MethodExecutor>>();
    private String artifactId;

    public MethodExecutor generate(Object targetInstance, Method method, ArgumentResolverDelegate argumentResolverDelegate) {
        return this.generate(targetInstance, method, argumentResolverDelegate, null);
    }

    public MethodExecutor generate(Object targetInstance, Method method, ArgumentResolverDelegate argumentResolverDelegate, File generatedByteCodeFile) {
        Class<MethodExecutor> generatedClass = this.getExecutorClass(method, generatedByteCodeFile);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(targetInstance);
        List<ArgumentResolver<?>> argumentResolvers = Arrays.asList(argumentResolverDelegate.getArgumentResolvers());
        args.addAll(argumentResolvers);
        if (LOGGER.isTraceEnabled()) {
            for (ArgumentResolver<?> argumentResolver : argumentResolvers) {
                LOGGER.debug("Argument resolver for {}: {}", (Object)generatedClass.getName(), argumentResolver);
            }
        }
        try {
            return (MethodExecutor)generatedClass.getConstructors()[0].newInstance(args.toArray(new Object[args.size()]));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not instantiate dynamic %s for method %s", MethodExecutor.class.getName(), method.toString())), (Throwable)e);
        }
    }

    private Class<MethodExecutor> getExecutorClass(Method method, File generatedByteCodeFile) {
        String executorName = this.getExecutorName(method) + "_" + this.getExecutorClassSuffix();
        return this.executorClasses.computeIfAbsent(executorName, key -> this.generateExecutorClass((String)key, method, generatedByteCodeFile));
    }

    private String getExecutorClassSuffix() {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(this.artifactId.charAt(0))) {
            sb.append("_");
        }
        for (char c : this.artifactId.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Class<MethodExecutor> generateExecutorClass(String executorName, final Method method, File generatedByteCodeFile) {
        CompositeClassLoader executorClassLoader = CompositeClassLoader.from((ClassLoader)method.getDeclaringClass().getClassLoader(), (ClassLoader)this.getClass().getClassLoader());
        try {
            return Class.forName(executorName, true, (ClassLoader)executorClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DynamicType.Builder.FieldDefinition.Optional.Valuable operationWrapperClassBuilder = new ByteBuddy().subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).implement(new Type[]{MethodExecutor.class}).name(executorName).defineField(TARGET_INSTANCE_FIELD_NAME, method.getDeclaringClass(), new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.FINAL});
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                operationWrapperClassBuilder = operationWrapperClassBuilder.defineField(this.getParameterFieldName(method.getParameters()[i]), (TypeDefinition)TypeDescription.Generic.Builder.parameterizedType(ArgumentResolver.class, (Type[])new Type[]{method.getParameterTypes()[i]}).build(), new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.FINAL});
            }
            DynamicType.Builder.MethodDefinition.ParameterDefinition.Annotatable constructorDefinition = operationWrapperClassBuilder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(method.getDeclaringClass(), TARGET_INSTANCE_FIELD_NAME, new ModifierContributor.ForParameter[0]);
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                constructorDefinition = constructorDefinition.withParameter((TypeDefinition)TypeDescription.Generic.Builder.parameterizedType(ArgumentResolver.class, (Type[])new Type[]{method.getParameterTypes()[i]}).build(), this.getParameterFieldName(method.getParameters()[i]), new ModifierContributor.ForParameter[0]);
            }
            DynamicType.Unloaded byteBuddyMadeWrapper = constructorDefinition.intercept(new Implementation(){

                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return (methodVisitor, instrumentationContext, instrumentedMethod) -> {
                        ArrayList<Object> stackManipulationItems = new ArrayList<Object>();
                        stackManipulationItems.add(MethodVariableAccess.REFERENCE.loadFrom(0));
                        stackManipulationItems.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Object.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly())));
                        stackManipulationItems.add(MethodVariableAccess.REFERENCE.loadFrom(0));
                        stackManipulationItems.add(MethodVariableAccess.REFERENCE.loadFrom(1));
                        stackManipulationItems.add(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)MethodExecutorGenerator.TARGET_INSTANCE_FIELD_NAME))).getOnly())).write());
                        for (int i = 0; i < method.getParameterTypes().length; ++i) {
                            stackManipulationItems.add(MethodVariableAccess.REFERENCE.loadFrom(0));
                            stackManipulationItems.add(MethodVariableAccess.REFERENCE.loadFrom(i + 2));
                            stackManipulationItems.add(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)MethodExecutorGenerator.this.getParameterFieldName(method.getParameters()[i])))).getOnly())).write());
                        }
                        stackManipulationItems.add(MethodReturn.VOID);
                        StackManipulation.Size size = new StackManipulation.Compound(stackManipulationItems).apply(methodVisitor, instrumentationContext);
                        return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
                    };
                }
            }).defineMethod("execute", Object.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(ExecutionContext.class, "executionContext", new ModifierContributor.ForParameter[0]).throwing(new Type[]{Exception.class}).intercept((Implementation)MethodCall.invoke((Method)method).onField(TARGET_INSTANCE_FIELD_NAME).with(new MethodCall.ArgumentLoader.Factory[]{this.getArgumentLoaders(method)}).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make();
            if (generatedByteCodeFile == null && LOGGER.isTraceEnabled()) {
                generatedByteCodeFile = new File(executorName + ".class");
            }
            if (generatedByteCodeFile != null) {
                try (FileOutputStream os = new FileOutputStream(generatedByteCodeFile);){
                    os.write(byteBuddyMadeWrapper.getBytes());
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not store bytecode while generating a dynamic %s for method %s", MethodExecutor.class, method.toString())), (Throwable)e);
                }
                LOGGER.trace("Generated class '{}' saved at '{}'", (Object)executorName, (Object)generatedByteCodeFile.getAbsoluteFile());
            }
            try {
                return byteBuddyMadeWrapper.load((ClassLoader)executorClassLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not generate MethodExecutor class for method " + method.toString())), (Throwable)e);
            }
        }
    }

    private String getExecutorName(Method method) {
        return method.getDeclaringClass().getName() + "$" + method.getName() + "$MethodComponentExecutor";
    }

    private MethodCall.ArgumentLoader.Factory getArgumentLoaders(final Method method) {
        return new MethodCall.ArgumentLoader.Factory(){

            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public MethodCall.ArgumentLoader.ArgumentProvider make(Implementation.Target implementationTarget) {
                MethodDescription.InDefinedShape resolveInvocation = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ArgumentResolver.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"resolve"))).getOnly();
                return (instrumentedMethod, invokedMethod) -> {
                    int parameterCount = method.getParameterCount();
                    ArrayList<MethodCall.ArgumentLoader> loaders = new ArrayList<MethodCall.ArgumentLoader>(parameterCount);
                    for (int i = 0; i < parameterCount; ++i) {
                        Parameter parameter = method.getParameters()[i];
                        Class<?> parameterType = parameter.getType();
                        String parameterFieldName = MethodExecutorGenerator.this.getParameterFieldName(parameter);
                        loaders.add((target, assigner, typing) -> {
                            FieldDescription fieldDescription = (FieldDescription)((FieldList)instrumentedMethod.getDeclaringType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)parameterFieldName))).getOnly();
                            LinkedList<Object> stack = new LinkedList<Object>();
                            stack.add(MethodVariableAccess.loadThis());
                            stack.add(FieldAccess.forField((FieldDescription)fieldDescription).read());
                            stack.add(MethodVariableAccess.REFERENCE.loadFrom(1));
                            stack.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)resolveInvocation));
                            stack.add(assigner.assign(new TypeDescription.ForLoadedType(Object.class).asGenericType(), new TypeDescription.ForLoadedType(parameterType).asGenericType(), typing));
                            return new StackManipulation.Compound(stack);
                        });
                    }
                    return loaders;
                };
            }
        };
    }

    private String getParameterFieldName(Parameter parameter) {
        return parameter.getName() + "Resolver";
    }

    @Inject
    public void setContext(MuleContext context) {
        this.setArtifactId(context.getConfiguration().getId());
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }
}

