/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.List;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.StackableTypesModelPropertyResolver;

public final class ParameterDeclarationContext {
    private static final StackableTypesModelPropertyResolver STACKABLE_TYPES_RESOLVER = StackableTypesModelPropertyResolver.newInstance();
    private final String componentName;
    private final String componentType;

    public static ParameterDeclarationContext forConfig(String configName) {
        return new ParameterDeclarationContext(configName, "Configuration");
    }

    public static ParameterDeclarationContext forOperation(String operationName) {
        return new ParameterDeclarationContext(operationName, "Operation");
    }

    public static ParameterDeclarationContext forSource(String sourceName) {
        return new ParameterDeclarationContext(sourceName, "Source");
    }

    public static ParameterDeclarationContext forConnectionProvider(String connectionProviderName) {
        return new ParameterDeclarationContext(connectionProviderName, "Connection Provider");
    }

    public static ParameterDeclarationContext forFunction(String functionName) {
        return new ParameterDeclarationContext(functionName, "Function");
    }

    public static ParameterDeclarationContext forRoute(String routeName) {
        return new ParameterDeclarationContext(routeName, "Route");
    }

    public ParameterDeclarationContext(String componentName, String componentType) {
        this.componentName = componentName;
        this.componentType = componentType;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public List<ModelProperty> resolveStackableTypes(ExtensionParameter extensionParameter) {
        return STACKABLE_TYPES_RESOLVER.resolveStackableProperties(extensionParameter, this);
    }
}

