/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.stereotype.ComponentId;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.validation.ModelValidationUtils;

public final class JavaParameterTypeModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        if (!ModelValidationUtils.isCompiletime(extensionModel)) {
            return;
        }
        new ExtensionWalker(){

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                JavaParameterTypeModelValidator.this.validateParameterType(model, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateParameterType(final ParameterModel parameter, final ProblemsReporter problemsReporter) {
        parameter.getType().accept(new MetadataTypeVisitor(){
            private final Set<MetadataType> visitedTypes = new HashSet<MetadataType>();

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitObject(ObjectType objectType) {
                if (!this.visitedTypes.add((MetadataType)objectType)) {
                    return;
                }
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    objectType.getAnnotation(ClassInformationAnnotation.class).filter(classInformation -> !classInformation.getGenericTypes().isEmpty()).filter(classInformation -> !Objects.equals(classInformation.getGenericTypes().get(0), String.class.getName())).ifPresent(classInformation -> problemsReporter.addError(new Problem((NamedObject)parameter, String.format("Parameter '%s' is of type '%s' and its key type is not %s ", parameter.getName(), JavaTypeUtils.getType((MetadataType)objectType).getName(), String.class.getName()))));
                    ((MetadataType)objectType.getOpenRestriction().get()).accept((MetadataTypeVisitor)this);
                } else {
                    parameter.getModelProperty(ExtensionParameterDescriptorModelProperty.class).map(descriptor -> descriptor.getExtensionParameter().getType()).ifPresent(type -> {
                        String typeName = type.getName();
                        type.getFields().forEach(field -> this.checkInvalidFieldAnnotations((NamedObject)parameter, typeName, (FieldElement)field, (Class<? extends Annotation>)ConfigOverride.class, (Class<? extends Annotation>)ComponentId.class, (Class<? extends Annotation>)MetadataKeyId.class, (Class<? extends Annotation>)MetadataKeyPart.class));
                    });
                }
                objectType.getFields().forEach(f -> f.getValue().accept((MetadataTypeVisitor)this));
            }

            public void visitBoolean(BooleanType booleanType) {
                if (ClassUtils.isPrimitiveWrapper((Class)JavaTypeUtils.getType((MetadataType)booleanType))) {
                    problemsReporter.addError(new Problem((NamedObject)parameter, String.format("Parameter '%s' is of type '%s'. Use primitive type boolean instead.", parameter.getName(), Boolean.class.getName())));
                }
            }

            private void checkInvalidFieldAnnotations(NamedObject model, String typeName, FieldElement field, Class<? extends Annotation> ... invalidAnnotations) {
                for (Class<? extends Annotation> annotation : invalidAnnotations) {
                    if (!field.getAnnotation(annotation).isPresent()) continue;
                    problemsReporter.addError(new Problem(model, String.format("Type '%s' has a field with name '%s' declared as '%s', which is not allowed.", typeName, field.getName(), annotation.getSimpleName())));
                }
            }
        });
    }
}

