/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;

public final class ParameterAllowedStereotypesDeclarionEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new Enricher().enrich((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private static class Enricher {
        private Enricher() {
        }

        void enrich(ExtensionDeclaration extension) {
            final HashMap typesByClassName = new HashMap();
            extension.getTypes().forEach(type -> type.getAnnotation(ClassInformationAnnotation.class).ifPresent(st -> typesByClassName.put(st.getClassname(), type)));
            new IdempotentDeclarationWalker(){

                protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                    declaration.getModelProperty(ImplementingParameterModelProperty.class).ifPresent(param -> declaration.getAllowedStereotypeModels().addAll(this.getStereotypes(param.getParameter(), typesByClassName)));
                    declaration.getModelProperty(DeclaringMemberModelProperty.class).ifPresent(field -> declaration.getAllowedStereotypeModels().addAll(this.getStereotypes(field.getDeclaringField(), typesByClassName)));
                }
            }.walk(extension);
        }

        private List<StereotypeModel> getStereotypes(AnnotatedElement element, Map<String, ObjectType> typesByClassName) {
            Class<?> paramType;
            Type parameterizedType;
            if (element instanceof Field) {
                parameterizedType = ((Field)element).getGenericType();
                paramType = ((Field)element).getType();
            } else {
                parameterizedType = ((Parameter)element).getParameterizedType();
                paramType = ((Parameter)element).getType();
            }
            if (Collection.class.isAssignableFrom(paramType)) {
                return this.parameterizedTypeAnnotations(typesByClassName, parameterizedType, 0);
            }
            if (Map.class.isAssignableFrom(paramType)) {
                return this.parameterizedTypeAnnotations(typesByClassName, parameterizedType, 1);
            }
            if (paramType.isEnum()) {
                return Collections.emptyList();
            }
            return this.typeToAnnotations(typesByClassName, paramType);
        }

        private List<StereotypeModel> parameterizedTypeAnnotations(Map<String, ObjectType> typesByClassName, Type parameterizedType, int typeArgumentIndex) {
            if (parameterizedType instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)parameterizedType).getActualTypeArguments();
                Class mapParamType = actualTypeArguments[typeArgumentIndex] instanceof ParameterizedType ? (Class)((ParameterizedType)actualTypeArguments[typeArgumentIndex]).getRawType() : (actualTypeArguments[typeArgumentIndex] instanceof WildcardType ? Object.class : (Class)actualTypeArguments[typeArgumentIndex]);
                return this.typeToAnnotations(typesByClassName, mapParamType);
            }
            return Collections.emptyList();
        }

        private List<StereotypeModel> typeToAnnotations(Map<String, ObjectType> typesByClassName, Class<?> paramType) {
            if (!typesByClassName.containsKey(paramType.getCanonicalName())) {
                return Collections.emptyList();
            }
            return typesByClassName.get(paramType.getCanonicalName()).getAnnotation(StereotypeTypeAnnotation.class).map(st -> st.getAllowedStereotypes()).orElse(Collections.emptyList());
        }
    }
}

