/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.extension.internal.runtime.resolver.AbstractValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class RequiredParameterValueResolverWrapper<T>
extends AbstractValueResolverWrapper<T> {
    private final String parameterName;
    private final String literalValue;

    public RequiredParameterValueResolverWrapper(ValueResolver<T> delegate, String parameterName, String literalValue) {
        super(delegate);
        this.parameterName = parameterName;
        this.literalValue = literalValue;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        Object value = super.resolve(context);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Required parameter '%s' was assigned with value '%s' which resolved to null. Required parameters need to be assigned with non null values", this.parameterName, this.literalValue));
        }
        return value;
    }
}

