/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImmutableLiteral;

public class LiteralArgumentResolver<T>
implements ArgumentResolver<Literal<T>> {
    private final Class<T> expectedType;
    private final ByParameterNameArgumentResolver argumentResolver;

    public LiteralArgumentResolver(String parameterName, Class<T> expectedType) {
        this.argumentResolver = new ByParameterNameArgumentResolver(parameterName);
        this.expectedType = expectedType;
    }

    @Override
    public Literal<T> resolve(ExecutionContext executionContext) {
        Object value = this.argumentResolver.resolve(executionContext);
        if (value instanceof Literal) {
            return (Literal)value;
        }
        if (value == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)(value instanceof String), (String)"Resolved value was expected to be a String");
        return new ImmutableLiteral<T>((String)value, this.expectedType);
    }
}

