/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.annotation.values.ValuePart;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterizableTypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ValueProvidersParameterDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        Optional<ImplementingTypeModelProperty> implementingType = this.extractImplementingTypeProperty((BaseDeclaration<? extends BaseDeclaration>)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(Thread.currentThread().getContextClassLoader());
        if (implementingType.isPresent()) {
            new IdempotentDeclarationWalker(){

                public void onSource(SourceDeclaration declaration) {
                    ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, typeLoader);
                }

                public void onOperation(OperationDeclaration declaration) {
                    ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, typeLoader);
                }

                protected void onConfiguration(ConfigurationDeclaration declaration) {
                    ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, typeLoader);
                }

                protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                    ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, typeLoader);
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }
    }

    private void enrichContainerModel(ParameterizedDeclaration<?> containerDeclaration, ClassTypeLoader typeLoader) {
        List allParameters = containerDeclaration.getAllParameters();
        Map<String, String> parameterNames = this.getContainerParameterNames(allParameters);
        Map<ParameterGroupDeclaration, OfValues> dynamicGroupOptions = this.introspectParameterGroups(containerDeclaration.getParameterGroups());
        Map<ParameterDeclaration, OfValues> dynamicOptions = this.introspectParameters(allParameters);
        dynamicOptions.forEach((paramDeclaration, resolverClass) -> this.enrichParameter((OfValues)resolverClass, (BaseDeclaration)paramDeclaration, arg_0 -> ((ParameterDeclaration)paramDeclaration).setValueProviderModel(arg_0), 1, parameterNames, paramDeclaration.getName(), typeLoader));
        dynamicGroupOptions.forEach((paramGroupDeclaration, resolverClass) -> this.getParts((ParameterGroupDeclaration)paramGroupDeclaration).forEach((paramDeclaration, order) -> this.enrichParameter((OfValues)resolverClass, (BaseDeclaration)paramDeclaration, arg_0 -> ((ParameterDeclaration)paramDeclaration).setValueProviderModel(arg_0), (Integer)order, parameterNames, paramGroupDeclaration.getName(), typeLoader)));
    }

    private void enrichParameter(OfValues resolverClass, BaseDeclaration paramDeclaration, Consumer<ValueProviderModel> valueProviderModelConsumer, Integer partOrder, Map<String, String> containerParameterNames, String name, ClassTypeLoader typeLoader) {
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder propertyBuilder = ValueProviderFactoryModelProperty.builder(resolverClass.value());
        ParameterizableTypeWrapper resolverClassWrapper = new ParameterizableTypeWrapper(resolverClass.value());
        List<ExtensionParameter> resolverParameters = resolverClassWrapper.getParametersAnnotatedWith(Parameter.class);
        resolverParameters.forEach(param -> propertyBuilder.withInjectableParameter(param.getName(), param.getMetadataType(typeLoader), param.isRequired()));
        Reference requiresConfiguration = new Reference((Object)false);
        Reference requiresConnection = new Reference((Object)false);
        this.enrichWithConnection(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
            Boolean cfr_ignored_0 = (Boolean)requiresConnection.set((Object)true);
        });
        this.enrichWithConfiguration(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
            Boolean cfr_ignored_0 = (Boolean)requiresConfiguration.set((Object)true);
        });
        paramDeclaration.addModelProperty((ModelProperty)propertyBuilder.build());
        valueProviderModelConsumer.accept(new ValueProviderModel(this.getRequiredParametersAliases(resolverParameters, containerParameterNames), ((Boolean)requiresConfiguration.get()).booleanValue(), ((Boolean)requiresConnection.get()).booleanValue(), resolverClass.open(), partOrder, name));
    }

    private Optional<Field> enrichWithConnection(ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder modelPropertyBuilder, ParameterizableTypeWrapper parameterizableComponent) {
        List<FieldElement> connectionFields = parameterizableComponent.getAnnotatedFields(Connection.class);
        if (!connectionFields.isEmpty()) {
            Field field = connectionFields.get(0).getField();
            modelPropertyBuilder.withConnection(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private Optional<Field> enrichWithConfiguration(ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder modelPropertyBuilder, ParameterizableTypeWrapper parameterizableComponent) {
        List<FieldElement> configFields = parameterizableComponent.getAnnotatedFields(Config.class);
        if (!configFields.isEmpty()) {
            Field field = configFields.get(0).getField();
            modelPropertyBuilder.withConfig(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private Map<ParameterDeclaration, OfValues> introspectParameters(List<ParameterDeclaration> parameters) {
        HashMap<ParameterDeclaration, OfValues> optionResolverEnabledParameters = new HashMap<ParameterDeclaration, OfValues>();
        parameters.forEach(param -> this.getAnnotation((ParameterDeclaration)param, (Class)OfValues.class).ifPresent(optionAnnotation -> optionResolverEnabledParameters.put((ParameterDeclaration)param, (OfValues)optionAnnotation)));
        return optionResolverEnabledParameters;
    }

    private Map<ParameterGroupDeclaration, OfValues> introspectParameterGroups(List<ParameterGroupDeclaration> parameterGroups) {
        HashMap<ParameterGroupDeclaration, OfValues> optionResolverEnabledParameters = new HashMap<ParameterGroupDeclaration, OfValues>();
        parameterGroups.forEach(paramGroup -> paramGroup.getModelProperty(ParameterGroupModelProperty.class).ifPresent(modelProperty -> {
            OfValues annotation;
            AnnotatedElement container = modelProperty.getDescriptor().getContainer();
            if (container != null && (annotation = container.getAnnotation(OfValues.class)) != null) {
                optionResolverEnabledParameters.put((ParameterGroupDeclaration)paramGroup, annotation);
            }
        }));
        return optionResolverEnabledParameters;
    }

    private <T extends Annotation> Optional<T> getAnnotation(ParameterDeclaration param, Class<T> annotationClass) {
        return IntrospectionUtils.getAnnotatedElement(param).map(annotatedElement -> Optional.ofNullable(annotatedElement.getAnnotation(annotationClass))).orElse(Optional.empty());
    }

    private List<String> getRequiredParametersAliases(List<ExtensionParameter> parameterDeclarations, Map<String, String> parameterNames) {
        return parameterDeclarations.stream().filter(ExtensionParameter::isRequired).map(param -> parameterNames.getOrDefault(param.getName(), param.getName())).collect(Collectors.toList());
    }

    private Map<ParameterDeclaration, Integer> getParts(ParameterGroupDeclaration paramDeclaration) {
        HashMap<ParameterDeclaration, Integer> parts = new HashMap<ParameterDeclaration, Integer>();
        paramDeclaration.getParameters().forEach(param -> this.getAnnotation((ParameterDeclaration)param, (Class)ValuePart.class).ifPresent(part -> parts.put((ParameterDeclaration)param, part.order())));
        return parts;
    }

    private Map<String, String> getContainerParameterNames(List<ParameterDeclaration> allParameters) {
        HashMap<String, String> parameterNames = new HashMap<String, String>();
        for (ParameterDeclaration parameterDeclaration : allParameters) {
            parameterNames.put(IntrospectionUtils.getImplementingName(parameterDeclaration), parameterDeclaration.getName());
        }
        return parameterNames;
    }
}

