/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.meta.model.declaration.fluent.AbstractParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;

public final class ParameterLayoutOrderDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private static final int INITIAL_ORDER = 1;

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        new IdempotentDeclarationWalker(){

            public void onOperation(OperationDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.establishOrder((ParameterizedDeclaration)declaration);
            }

            public void onConfiguration(ConfigurationDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.establishOrder((ParameterizedDeclaration)declaration);
            }

            public void onSource(SourceDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.establishOrder((ParameterizedDeclaration)declaration);
            }

            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.establishOrder((ParameterizedDeclaration)declaration);
            }
        }.walk(declaration);
    }

    private void establishOrder(ParameterizedDeclaration declaration) {
        this.addMissingParameterOrders(declaration.getAllParameters());
        int minGroupOrder = this.addMissingParameterOrders(declaration.getParameterGroups());
        this.updateGeneralGroupOrder(declaration, minGroupOrder);
    }

    private void updateGeneralGroupOrder(ParameterizedDeclaration declaration, int minGroupOrder) {
        Optional<Object> general = declaration.getParameterGroups().stream().filter(pg -> ((ParameterGroupDeclaration)pg).getName().equals("General")).findFirst();
        general.map(AbstractParameterDeclaration::getLayoutModel).flatMap(LayoutModel::getOrder).filter(order -> order > minGroupOrder).ifPresent(order -> ((ParameterGroupDeclaration)general.get()).setLayoutModel(LayoutModel.builderFrom((LayoutModel)((ParameterGroupDeclaration)general.get()).getLayoutModel()).order(minGroupOrder - 1).build()));
    }

    private int addMissingParameterOrders(List<AbstractParameterDeclaration> declarations) {
        AtomicInteger minOrder = new AtomicInteger(1);
        HashSet takenOrders = new HashSet();
        ArrayList nonOrderedParams = new ArrayList();
        declarations.forEach(param -> {
            LayoutModel layoutModel = param.getLayoutModel();
            if (layoutModel != null && layoutModel.getOrder().isPresent()) {
                takenOrders.add(layoutModel.getOrder().get());
                minOrder.set(Integer.min((Integer)layoutModel.getOrder().get(), minOrder.get()));
            } else {
                nonOrderedParams.add(param);
            }
        });
        AtomicInteger currentOrder = new AtomicInteger(1);
        nonOrderedParams.forEach(param -> param.setLayoutModel(LayoutModel.builderFrom((LayoutModel)param.getLayoutModel()).order(this.getNextOrder(currentOrder, takenOrders)).build()));
        return minOrder.get();
    }

    private int getNextOrder(AtomicInteger init, Set<Integer> takenOrders) {
        while (takenOrders.contains(init.get())) {
            init.incrementAndGet();
        }
        return init.getAndIncrement();
    }
}

