/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.api.execution.MessageProcessingManager;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.ModuleFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionSourceBinder;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class DefaultSourceCallback<T, A>
implements SourceCallbackAdapter<T, A> {
    private SourceModel sourceModel;
    private ConfigurationInstance configurationInstance;
    private Processor listener;
    private MuleContext muleContext;
    private ExtensionMessageSource messageSource;
    private ExceptionCallback<ConnectionException> exceptionCallback;
    private MessageProcessingManager messageProcessingManager;
    private Supplier<MessageProcessContext> processContextSupplier;
    private SourceCompletionHandlerFactory completionHandlerFactory;
    private CursorProviderFactory cursorProviderFactory;
    private TransactionConfig transactionConfig;
    private boolean returnsListOfMessages = false;
    private TransactionSourceBinder transactionSourceBinder;

    static Builder builder() {
        return new Builder();
    }

    private DefaultSourceCallback() {
    }

    public void handle(Result<T, A> result) {
        this.handle(result, this.createContext());
    }

    public void handle(Result<T, A> result, SourceCallbackContext context) {
        Preconditions.checkArgument((boolean)(context instanceof SourceCallbackContextAdapter), (String)"The supplied context was not created through this callback, you naughty developer");
        MessageProcessContext messageProcessContext = this.processContextSupplier.get();
        SourceResultAdapter resultAdapter = new SourceResultAdapter(result, this.cursorProviderFactory, this.returnsListOfMessages);
        Message message = Message.of((Object)resultAdapter);
        this.executeFlow(context, messageProcessContext, message);
    }

    private void executeFlow(SourceCallbackContext context, MessageProcessContext messageProcessContext, Message message) {
        this.messageProcessingManager.processMessage((MessageProcessTemplate)new ModuleFlowProcessingTemplate(message, this.listener, this.completionHandlerFactory.createCompletionHandler((SourceCallbackContextAdapter)context)), messageProcessContext);
    }

    public void onConnectionException(ConnectionException e) {
        this.exceptionCallback.onException((Throwable)e);
    }

    public SourceCallbackContext createContext() {
        return new DefaultSourceCallbackContext(this, this.muleContext);
    }

    @Override
    public TransactionSourceBinder getTransactionSourceBinder() {
        return this.transactionSourceBinder;
    }

    @Override
    public ConfigurationInstance getConfigurationInstance() {
        return this.configurationInstance;
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public SourceConnectionManager getSourceConnectionManager() {
        return this.messageSource.getSourceConnectionManager();
    }

    static class Builder<T, A> {
        private DefaultSourceCallback<T, A> product = new DefaultSourceCallback();

        private Builder() {
        }

        public Builder<T, A> setSourceModel(SourceModel sourceModel) {
            ((DefaultSourceCallback)this.product).sourceModel = sourceModel;
            ((DefaultSourceCallback)this.product).returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages((HasOutputModel)sourceModel);
            return this;
        }

        public Builder<T, A> setConfigurationInstance(ConfigurationInstance configurationInstance) {
            ((DefaultSourceCallback)this.product).configurationInstance = configurationInstance;
            return this;
        }

        public Builder<T, A> setTransactionConfig(TransactionConfig transactionConfig) {
            ((DefaultSourceCallback)this.product).transactionConfig = transactionConfig;
            return this;
        }

        public Builder<T, A> setListener(Processor listener) {
            ((DefaultSourceCallback)this.product).listener = listener;
            return this;
        }

        public Builder<T, A> setMuleContext(MuleContext muleContext) {
            ((DefaultSourceCallback)this.product).muleContext = muleContext;
            return this;
        }

        public Builder<T, A> setSource(ExtensionMessageSource messageSource) {
            ((DefaultSourceCallback)this.product).messageSource = messageSource;
            return this;
        }

        public Builder<T, A> setExceptionCallback(ExceptionCallback<ConnectionException> exceptionCallback) {
            ((DefaultSourceCallback)this.product).exceptionCallback = exceptionCallback;
            return this;
        }

        public Builder<T, A> setProcessingManager(MessageProcessingManager processingManager) {
            ((DefaultSourceCallback)this.product).messageProcessingManager = processingManager;
            return this;
        }

        public Builder<T, A> setProcessContextSupplier(Supplier<MessageProcessContext> processContextSupplier) {
            ((DefaultSourceCallback)this.product).processContextSupplier = processContextSupplier;
            return this;
        }

        public Builder<T, A> setCompletionHandlerFactory(SourceCompletionHandlerFactory completionHandlerFactory) {
            ((DefaultSourceCallback)this.product).completionHandlerFactory = completionHandlerFactory;
            return this;
        }

        public Builder<T, A> setCursorStreamProviderFactory(CursorProviderFactory cursorProviderFactory) {
            ((DefaultSourceCallback)this.product).cursorProviderFactory = cursorProviderFactory;
            return this;
        }

        public SourceCallback<T, A> build() {
            this.checkArgument(((DefaultSourceCallback)this.product).listener, "listener");
            this.checkArgument(((DefaultSourceCallback)this.product).exceptionCallback, "exceptionCallback");
            this.checkArgument(((DefaultSourceCallback)this.product).messageProcessingManager, "messageProcessingManager");
            this.checkArgument(((DefaultSourceCallback)this.product).processContextSupplier, "processContextSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).completionHandlerFactory, "completionHandlerSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).sourceModel, "source");
            this.checkArgument(((DefaultSourceCallback)this.product).cursorProviderFactory, "cursorStreamProviderFactory");
            this.checkArgument((Object)((DefaultSourceCallback)this.product).messageSource, "messageSource");
            this.checkArgument(((DefaultSourceCallback)this.product).muleContext, "muleContext");
            ((DefaultSourceCallback)this.product).transactionSourceBinder = new TransactionSourceBinder(((DefaultSourceCallback)this.product).messageSource.getExtensionModel(), (ComponentModel)((DefaultSourceCallback)this.product).sourceModel, ((DefaultSourceCallback)this.product).muleContext);
            return this.product;
        }

        private void checkArgument(Object value, String name) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)(name + " was not set"));
        }
    }
}

