/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.function;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectiveExpressionFunctionExecutor
implements Lifecycle,
FunctionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveExpressionFunctionExecutor.class);
    private final Method method;
    private final FunctionModel model;
    private final DataType returnType;
    private final Object componentInstance;
    private final ClassLoader extensionClassLoader;
    private final List<FunctionParameter> functionParameters;

    public ReflectiveExpressionFunctionExecutor(FunctionModel model, DataType returnType, List<FunctionParameter> functionParameters, Method method, Object componentInstance) {
        this.model = model;
        this.method = method;
        this.returnType = returnType;
        this.componentInstance = componentInstance;
        this.functionParameters = functionParameters;
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
    }

    public Object call(Object[] parameters, BindingContext context) {
        return ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, () -> ReflectionUtils.invokeMethod((Method)this.method, (Object)this.componentInstance, (Object[])parameters));
    }

    public Optional<DataType> returnType() {
        return Optional.ofNullable(this.returnType);
    }

    public List<FunctionParameter> parameters() {
        return this.functionParameters;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.componentInstance);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentInstance);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.componentInstance);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.componentInstance, (Logger)LOGGER);
    }
}

