/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class PrivilegedApiValidator
implements ExtensionModelValidator {
    static final String NO_PRIVILEGED_ARTIFACTS_ERROR = "Extension has privileged packages but no privileged artifacts defined";
    static final String NO_PRIVILEGED_PACKAGES_ERROR = "Extension has privileged artifacts but no privileged packages defined";

    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) throws IllegalModelDefinitionException {
        boolean hasPrivilegedArtifacts;
        boolean hasPrivilegedPackages = model.getPrivilegedPackages() != null && !model.getPrivilegedPackages().isEmpty();
        boolean bl = hasPrivilegedArtifacts = model.getPrivilegedArtifacts() != null && !model.getPrivilegedArtifacts().isEmpty();
        if (hasPrivilegedPackages != hasPrivilegedArtifacts) {
            if (hasPrivilegedPackages) {
                problemsReporter.addError(new Problem((NamedObject)model, NO_PRIVILEGED_ARTIFACTS_ERROR));
            } else {
                problemsReporter.addError(new Problem((NamedObject)model, NO_PRIVILEGED_PACKAGES_ERROR));
            }
        }
    }
}

