/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.List;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

class CollectionSchemaDelegate {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SchemaBuilder builder;

    CollectionSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
    }

    void generateCollectionElement(ArrayType metadataType, DslElementSyntax collectionDsl, String description, boolean required, List<TopLevelElement> all) {
        LocalComplexType collectionComplexType = this.generateCollectionComplexType(collectionDsl, metadataType);
        TopLevelElement collectionElement = this.builder.createTopLevelElement(collectionDsl.getElementName(), required ? BigInteger.ONE : BigInteger.ZERO, "1");
        collectionElement.setAnnotation(this.builder.createDocAnnotation(description));
        collectionElement.setComplexType(collectionComplexType);
        all.add(collectionElement);
    }

    private LocalComplexType generateCollectionComplexType(DslElementSyntax collectionDsl, ArrayType metadataType) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        final ExplicitGroup sequence = new ExplicitGroup();
        final MetadataType genericType = metadataType.getType();
        final DslElementSyntax itemDsl = (DslElementSyntax)collectionDsl.getGeneric(genericType).orElseThrow(() -> new IllegalArgumentException(String.format("Missing item's DSL information for collection [%s]", collectionDsl.getAttributeName())));
        genericType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                DslElementSyntax typeDsl = (DslElementSyntax)CollectionSchemaDelegate.this.builder.getDslResolver().resolve((MetadataType)objectType).orElseThrow(() -> new IllegalArgumentException(String.format("The given type [%s] cannot be represented as a collection item", ExtensionMetadataTypeUtils.getId((MetadataType)objectType))));
                if (typeDsl.isWrapped()) {
                    ExplicitGroup choice = CollectionSchemaDelegate.this.builder.createTypeRefChoiceLocalOrGlobal(typeDsl, (MetadataType)objectType, BigInteger.ZERO, "unbounded");
                    sequence.getParticle().add(CollectionSchemaDelegate.this.objectFactory.createChoice(choice));
                } else {
                    TopLevelElement collectionItemElement = CollectionSchemaDelegate.this.builder.createTypeRef(typeDsl, objectType, false);
                    collectionItemElement.setMaxOccurs("unbounded");
                    sequence.getParticle().add(CollectionSchemaDelegate.this.objectFactory.createElement(collectionItemElement));
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                LocalComplexType complexType = new LocalComplexType();
                complexType.getAttributeOrAttributeGroup().add(CollectionSchemaDelegate.this.builder.createValueAttribute(genericType));
                TopLevelElement collectionItemElement = CollectionSchemaDelegate.this.builder.createTopLevelElement(itemDsl.getElementName(), BigInteger.ZERO, "unbounded");
                collectionItemElement.setComplexType(complexType);
                sequence.getParticle().add(CollectionSchemaDelegate.this.objectFactory.createElement(collectionItemElement));
            }
        });
        collectionComplexType.setSequence(sequence);
        return collectionComplexType;
    }
}

