/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.util.Collections;
import java.util.Optional;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.resources.manifest.ExportedArtifactsCollector;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;

public class MulePluginDescriptorGenerator
implements GeneratedResourceFactory {
    private static final String AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR = "auto-generated-mule-artifact.json";

    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        Optional typeProperty = extensionModel.getModelProperty(ImplementingTypeModelProperty.class);
        if (!typeProperty.isPresent()) {
            return Optional.empty();
        }
        ExportedArtifactsCollector exportCollector = new ExportedArtifactsCollector(extensionModel);
        MulePluginModel.MulePluginModelBuilder builder = new MulePluginModel.MulePluginModelBuilder();
        builder.setName(extensionModel.getName());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptorBuilder().setId("mule").addProperty("exportedPackages", (Object)exportCollector.getExportedPackages()).addProperty("exportedResources", (Object)exportCollector.getExportedResources()).addProperty("privilegedExportedPackages", (Object)exportCollector.getPrivilegedExportedPackages()).addProperty("privilegedArtifactIds", (Object)exportCollector.getPrivilegedArtifacts()).build());
        builder.withExtensionModelDescriber().setId(this.getLoaderId(extensionModel)).addProperty("type", (Object)((ImplementingTypeModelProperty)typeProperty.get()).getType().getName()).addProperty("version", (Object)extensionModel.getVersion());
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        Optional licenseModelPropertyOptional = extensionModel.getModelProperty(LicenseModelProperty.class);
        builder.setRequiredProduct(extensionModel.getCategory().equals((Object)Category.COMMUNITY) ? Product.MULE : Product.MULE_EE);
        licenseModelPropertyOptional.ifPresent(licenseModelProperty -> {
            builder.setRequiredProduct(licenseModelProperty.requiresEeLicense() ? Product.MULE_EE : Product.MULE);
            if (licenseModelProperty.requiresEeLicense()) {
                builder.withLicenseModel().setAllowsEvaluationLicense(licenseModelProperty.isAllowsEvaluationLicense());
                licenseModelProperty.getRequiredEntitlement().ifPresent(requiredEntitlement -> builder.withLicenseModel().setProvider(extensionModel.getVendor()).setRequiredEntitlement(requiredEntitlement));
            }
        });
        String descriptorJson = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)builder.build());
        return Optional.of(new GeneratedResource(AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR, descriptorJson.getBytes()));
    }

    private String getLoaderId(ExtensionModel extensionModel) {
        Optional soapModelProperty = extensionModel.getModelProperty(SoapExtensionModelProperty.class);
        return soapModelProperty.isPresent() ? "soap" : "java";
    }
}

