/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.spring.dsl.api.xml.SchemaConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ExecutableTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

class SourceSchemaDelegate
extends ExecutableTypeSchemaDelegate {
    SourceSchemaDelegate(SchemaBuilder builder) {
        super(builder);
    }

    void registerMessageSource(SourceModel sourceModel, DslElementSyntax dslSyntax) {
        String typeName = StringUtils.capitalize((String)sourceModel.getName()) + "Type";
        this.registerSourceElement(sourceModel, typeName, dslSyntax);
        this.registerSourceType(typeName, sourceModel, dslSyntax);
    }

    private void registerSourceElement(SourceModel sourceModel, String typeName, DslElementSyntax dslSyntax) {
        TopLevelElement element = new TopLevelElement();
        element.setName(dslSyntax.getElementName());
        element.setType(new QName(this.builder.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.builder.createDocAnnotation(sourceModel.getDescription()));
        element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerSourceType(String name, SourceModel sourceModel, DslElementSyntax dslSyntax) {
        ExtensionType sourceType = this.createExecutableType(name, SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE_TYPE, dslSyntax);
        this.initialiseSequence(sourceType);
        ExplicitGroup sequence = sourceType.getSequence();
        this.builder.addInfrastructureParameters(sourceType, (ParameterizedModel)sourceModel, sequence);
        LinkedList visitedParameters = new LinkedList();
        sourceModel.getParameterGroupModels().forEach(group -> {
            this.registerParameterGroup(sourceType, (ParameterGroupModel)group);
            visitedParameters.addAll(group.getParameterModels());
        });
        sourceModel.getSuccessCallback().map(ParameterizedModel::getParameterGroupModels).ifPresent(groups -> groups.forEach(group -> this.registerCallbackParameters(sourceType, visitedParameters, (ParameterGroupModel)group)));
        sourceModel.getErrorCallback().map(ParameterizedModel::getParameterGroupModels).ifPresent(groups -> groups.forEach(group -> this.registerCallbackParameters(sourceType, visitedParameters, (ParameterGroupModel)group)));
    }

    private void registerCallbackParameters(ExtensionType sourceType, List<ParameterModel> visitedParameters, ParameterGroupModel group) {
        if (group.isShowInDsl()) {
            this.builder.addInlineParameterGroup(group, sourceType.getSequence());
        } else {
            List<ParameterModel> callbackParameters = group.getParameterModels().stream().filter(p -> !visitedParameters.contains(p)).collect(Collectors.toList());
            this.registerParameters(sourceType, callbackParameters);
            visitedParameters.addAll(group.getParameterModels());
        }
    }
}

