/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ParameterDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class OperationDescriptionDocumenter
extends AbstractDescriptionDocumenter<WithOperationsDeclaration<?>> {
    private final ParameterDescriptionDocumenter parameterDeclarer;

    OperationDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.parameterDeclarer = new ParameterDescriptionDocumenter(processingEnv);
    }

    @Override
    void document(WithOperationsDeclaration<?> declaration, TypeElement element) {
        Map<String, Element> methods = this.getAllOperations(this.processingEnv, element);
        try {
            for (OperationDeclaration operation : declaration.getOperations()) {
                Element method = methods.get(operation.getName());
                if (method == null) continue;
                MethodDocumentation documentation = processor.getMethodDocumentation(this.processingEnv, method);
                operation.setDescription(documentation.getSummary());
                this.parameterDeclarer.document((ParameterizedDeclaration<?>)operation, documentation);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception found while trying to obtain descriptions"), (Throwable)e);
        }
    }

    private Map<String, Element> getAllOperations(ProcessingEnvironment processingEnv, Element element) {
        LinkedHashMap<String, Element> elements = new LinkedHashMap<String, Element>();
        Configurations configurations = (Configurations)processor.getAnnotationFromType(processingEnv, (TypeElement)element, Configurations.class);
        if (configurations != null) {
            List<TypeElement> configs = processor.getAnnotationClassesValue(element, Configurations.class, configurations.value());
            configs.forEach(c -> elements.putAll(this.getOperationMethodElements(processingEnv, (Element)c)));
        }
        elements.putAll(this.getOperationMethodElements(processingEnv, element));
        return elements;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Element> getOperationMethodElements(ProcessingEnvironment processingEnv, Element withOperationsElement) {
        ImmutableMap.Builder methods = ImmutableMap.builder();
        Operations operationsAnnotation = (Operations)processor.getAnnotationFromType(processingEnv, (TypeElement)withOperationsElement, Operations.class);
        if (operationsAnnotation != null) {
            Class[] operationsClasses;
            for (Class clazz : operationsClasses = operationsAnnotation.value()) {
                void var9_9;
                while (var9_9 != null && !var9_9.equals(Object.class)) {
                    TypeElement operationElement = processingEnv.getElementUtils().getTypeElement(var9_9.getName());
                    if (operationElement == null) continue;
                    for (Method operation : IntrospectionUtils.getApiMethods((Class)var9_9)) {
                        operationElement.getEnclosedElements().stream().filter(e -> e.getSimpleName().toString().equals(operation.getName())).findFirst().ifPresent(operationMethodElement -> methods.put((Object)operation.getName(), operationMethodElement));
                    }
                    Class clazz2 = var9_9.getSuperclass();
                }
            }
        }
        return methods.build();
    }
}

