/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelParameterObjectFactory
extends AbstractExtensionObjectFactory<Object>
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopLevelParameterObjectFactory.class);
    private DefaultObjectBuilder builder;
    private Class<?> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;
    private String name;
    private Object staticProduct = null;

    public TopLevelParameterObjectFactory(ObjectType type, ClassLoader classLoader, MuleContext muleContext) {
        super(muleContext);
        this.classLoader = classLoader;
        this.objectType = type;
        this.objectClass = (Class)ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> AnnotatedObjectInvocationHandler.addAnnotationsToClass((Class)JavaTypeUtils.getType((MetadataType)type)));
        this.builder = new DefaultObjectBuilder(this.objectClass);
    }

    public void initialise() throws InitialisationException {
        if (this.staticProduct != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.staticProduct, (boolean)true, (MuleContext)this.muleContext);
        }
    }

    public void start() throws MuleException {
        if (this.staticProduct != null) {
            LifecycleUtils.startIfNeeded((Object)this.staticProduct);
        }
    }

    public void stop() throws MuleException {
        if (this.staticProduct != null) {
            LifecycleUtils.stopIfNeeded((Object)this.staticProduct);
        }
    }

    public void dispose() {
        if (this.staticProduct != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.staticProduct, (Logger)LOGGER);
        }
    }

    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            this.resolveParameters(this.objectType, this.builder);
            this.resolveParameterGroups(this.objectType, this.builder);
            this.injectFields();
            ObjectBuilderValueResolver resolver = new ObjectBuilderValueResolver((ObjectBuilder)this.builder, this.muleContext);
            if (resolver.isDynamic()) {
                return resolver;
            }
            this.staticProduct = resolver.resolve(ValueResolvingContext.from((CoreEvent)MuleExtensionUtils.getInitialiserEvent((MuleContext)this.muleContext)));
            return this.staticProduct;
        }, Exception.class, exception -> {
            throw exception;
        });
    }

    private void injectFields() {
        this.builder.setEncoding(this.muleContext.getConfiguration().getDefaultEncoding());
        if (this.name != null) {
            this.builder.setName(this.name);
        }
    }

    public void setName(String name) {
        this.name = name;
    }
}

