/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.ic.internal.error.ConnectivityError;
import org.mule.runtime.http.api.HttpConstants;

public class ErrorMapper {
    private static final int HTTP_CLIENT_ERROR_START = 400;
    private static final int HTTP_CLIENT_ERROR_END = 500;
    private static final int HTTP_SERVER_ERROR_START = 500;
    private static final int HTTP_SERVER_ERROR_END = 600;

    private ErrorMapper() {
    }

    public static String getHttpStatusName(String errorKind) {
        try {
            int statusCode = ErrorMapper.getStatusCode(errorKind);
            HttpConstants.HttpStatus httpStatus = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
            return httpStatus != null ? httpStatus.name() : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int getStatusCode(String statusCode) {
        return Integer.parseInt(statusCode);
    }

    public static boolean isStatusCode(String statusCode) {
        try {
            Integer.parseInt(statusCode);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static ErrorTypeDefinition<?> mapStatusCodeToErrorType(int statusCode) {
        if (ErrorMapper.isClientError(statusCode)) {
            return ConnectivityError.CLIENT_ERROR;
        }
        if (ErrorMapper.isServerError(statusCode)) {
            return ConnectivityError.SERVER_ERROR;
        }
        return MuleErrors.ANY;
    }

    private static boolean isClientError(int statusCode) {
        return statusCode >= 400 && statusCode < 500;
    }

    private static boolean isServerError(int statusCode) {
        return statusCode >= 500 && statusCode < 600;
    }
}

