/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;

public enum ConnectivityError implements ErrorTypeDefinition<ConnectivityError>
{
    CONNECTIVITY((ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY),
    SECURITY((ErrorTypeDefinition<?>)MuleErrors.SECURITY),
    CLIENT_ERROR((ErrorTypeDefinition<?>)MuleErrors.ANY),
    SERVER_ERROR((ErrorTypeDefinition<?>)MuleErrors.ANY),
    UNAUTHORIZED(SECURITY),
    FORBIDDEN(SECURITY),
    TIMEOUT(CLIENT_ERROR);

    private static final List<ErrorTypeDefinition<ConnectivityError>> ERROR_TYPE_LIST;
    private ErrorTypeDefinition<?> parentErrorType;

    private ConnectivityError() {
    }

    private ConnectivityError(ErrorTypeDefinition<?> parentErrorType) {
        this.parentErrorType = parentErrorType;
    }

    public static List<ErrorTypeDefinition<ConnectivityError>> getErrorTypeList() {
        return ERROR_TYPE_LIST;
    }

    public static ConnectivityError fromString(String errorType) {
        for (ConnectivityError error : ConnectivityError.values()) {
            if (!error.name().equals(errorType)) continue;
            return error;
        }
        return null;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parentErrorType);
    }

    static {
        ERROR_TYPE_LIST = List.of(CONNECTIVITY, SECURITY, CLIENT_ERROR, SERVER_ERROR, UNAUTHORIZED, FORBIDDEN, TIMEOUT);
    }
}

