/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.module.deployment.internal.NativeLibrariesFolderDeletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryScheduledFolderDeletionTask
implements Runnable {
    private final ScheduledExecutorService scheduler;
    private final int maxAttempts;
    private final AtomicInteger attempts;
    private final NativeLibrariesFolderDeletion folderDeletion;
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryScheduledFolderDeletionTask.class);
    private static final boolean DISABLE_NATIVE_LIBRARIES_FOLDER_DELETION_GC_CALL = Boolean.parseBoolean(System.getProperty("mule.disable.nativeLibrariesFolderDeletion.gc.call", "false"));

    public RetryScheduledFolderDeletionTask(ScheduledExecutorService scheduler, int maxAttempts, NativeLibrariesFolderDeletion folderDeletion) {
        this.scheduler = scheduler;
        this.maxAttempts = maxAttempts;
        this.attempts = new AtomicInteger(0);
        this.folderDeletion = folderDeletion;
    }

    @Override
    public void run() {
        int attempt = this.attempts.incrementAndGet();
        if (!DISABLE_NATIVE_LIBRARIES_FOLDER_DELETION_GC_CALL && attempt == this.maxAttempts) {
            System.gc();
            LOGGER.debug("Attempt {}. System.gc() executed.", (Object)attempt);
        }
        if (this.performAction()) {
            this.scheduler.shutdown();
        } else if (attempt >= this.maxAttempts) {
            LOGGER.error("Failed to perform the action. No further retries will be made.");
            this.scheduler.shutdown();
        } else {
            LOGGER.warn("Attempt {}. Failed to perform the action. Retrying...", (Object)attempt);
        }
    }

    private boolean performAction() {
        return this.folderDeletion.doAction();
    }
}

