/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.NotImplementedException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainArchiveDeployer
implements ArchiveDeployer<DomainDescriptor, Domain> {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DOMAIN_BUNDLE_APPS_FOLDER = "apps";
    private final ArchiveDeployer<DomainDescriptor, Domain> domainDeployer;
    private final DeploymentService deploymentService;
    private final ArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer;

    public DomainArchiveDeployer(ArchiveDeployer<DomainDescriptor, Domain> domainDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer, DeploymentService deploymentService) {
        this.domainDeployer = domainDeployer;
        this.applicationDeployer = applicationDeployer;
        this.deploymentService = deploymentService;
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        return true;
    }

    @Override
    public void undeployArtifact(String artifactId) {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifactId);
        for (Application domainApplication : domainApplications) {
            this.applicationDeployer.undeployArtifact(domainApplication.getArtifactName());
        }
        this.domainDeployer.undeployArtifact(artifactId);
    }

    private Collection<Application> findApplicationsAssociated(String artifactId) {
        Domain domain = this.deploymentService.findDomain(artifactId);
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)String.format("Domain %s does not exists", artifactId));
        return this.findApplicationsAssociated(domain);
    }

    private Collection<Application> findApplicationsAssociated(Domain domain) {
        return this.deploymentService.findDomainApplications(domain.getArtifactName());
    }

    @Override
    public File getDeploymentDirectory() {
        return this.domainDeployer.getDeploymentDirectory();
    }

    @Override
    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.domainDeployer.setDeploymentListener(deploymentListener);
    }

    @Override
    public Map<String, Map<URI, Long>> getArtifactsZombieMap() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<DomainDescriptor, Domain> artifactFactory) {
        this.domainDeployer.setArtifactFactory(artifactFactory);
    }

    @Override
    public void undeployArtifactWithoutUninstall(Domain artifact) {
        throw new NotImplementedException("undeploy without uninstall is not supported for domains");
    }

    @Override
    public Domain deployPackagedArtifact(URI domainArchiveUri, Optional<Properties> appProperties) throws DeploymentException {
        return this.domainDeployer.deployPackagedArtifact(domainArchiveUri, appProperties);
    }

    @Override
    public Domain deployPackagedArtifact(String zip, Optional<Properties> deploymentProperties) throws DeploymentException {
        return this.domainDeployer.deployPackagedArtifact(zip, deploymentProperties);
    }

    @Override
    public void redeploy(String artifactName, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            this.domainDeployer.redeploy(artifactName, deploymentProperties);
        }
        catch (DeploymentException e) {
            this.logger.warn(String.format("Failure during redeployment of domain %s, domain applications deployment will be skipped", artifactName));
            throw e;
        }
    }

    @Override
    public void deployArtifact(Domain artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        this.domainDeployer.deployArtifact(artifact, deploymentProperties);
    }

    @Override
    public Domain deployExplodedArtifact(String artifactDir, Optional<Properties> deploymentProperties) {
        return this.domainDeployer.deployExplodedArtifact(artifactDir, deploymentProperties);
    }

    @Override
    public void doNotPersistArtifactStop(Domain artifact) {
        this.domainDeployer.doNotPersistArtifactStop(artifact);
    }
}

