/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileWatcher
implements Runnable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Collection<File> files;
    private Map<File, Long> timestamps = new HashMap<File, Long>();

    public AbstractFileWatcher(File file) {
        this(Arrays.asList(file));
    }

    public AbstractFileWatcher(Collection<File> files) {
        this.files = files;
        for (File file : files) {
            this.timestamps.put(file, file.lastModified());
        }
    }

    @Override
    public final void run() {
        File latestFile = null;
        for (File file : this.files) {
            long currentTimestamp;
            long originalTimestamp = this.timestamps.get(file);
            if (originalTimestamp == (currentTimestamp = file.lastModified())) continue;
            this.timestamps.put(file, currentTimestamp);
            latestFile = file;
        }
        if (latestFile != null) {
            try {
                this.onChange(latestFile);
            }
            catch (Throwable t) {
                this.logger.error(String.format("Monitor for %s threw an exception", latestFile), t);
            }
        }
    }

    protected abstract void onChange(File var1);
}

