/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ToolingRegionClassLoader
extends RegionClassLoader {
    private static final String CLASSLOADER_RELEASER_EXPLICIT_GC_SYSTEM_PROPERTY = "mule.tooling.runExplicitGC";
    private static final boolean shouldRunGC;

    public static ToolingRegionClassLoader newToolingRegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        if (shouldRunGC) {
            return new ToolingRegionClassLoader(artifactId, artifactDescriptor, parent, lookupPolicy);
        }
        return new ToolingRegionClassLoader(artifactId, artifactDescriptor, parent, lookupPolicy, () -> {});
    }

    private ToolingRegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(artifactId, artifactDescriptor, parent, lookupPolicy);
    }

    private ToolingRegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, ResourceReleaser regionResourceReleaser) {
        super(artifactId, artifactDescriptor, parent, lookupPolicy, regionResourceReleaser);
    }

    static {
        String shouldRunGCString = System.getProperty(CLASSLOADER_RELEASER_EXPLICIT_GC_SYSTEM_PROPERTY);
        shouldRunGC = shouldRunGCString != null ? Boolean.parseBoolean(shouldRunGCString) : false;
    }
}

