/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.artifact.extension;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.deployment.model.internal.artifact.extension.ExtensionModelLoaderManager;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleExtensionModelLoaderManager
implements ExtensionModelLoaderManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Class<ExtensionModelLoader> PROVIDER_CLASS = ExtensionModelLoader.class;
    private final Map<String, ExtensionModelLoader> extensionModelLoaders = Maps.newHashMap();
    private Supplier<Collection<ExtensionModelLoader>> extModelLoadersLookup;

    public MuleExtensionModelLoaderManager(ArtifactClassLoader containerClassLoader) {
        Objects.requireNonNull(containerClassLoader, "containerClassLoader cannot be null");
        this.extModelLoadersLookup = () -> new SpiServiceRegistry().lookupProviders(PROVIDER_CLASS, containerClassLoader.getClassLoader());
    }

    public void setExtensionModelLoadersLookup(Supplier<Collection<ExtensionModelLoader>> extModelLoadersLookup) {
        this.extModelLoadersLookup = extModelLoadersLookup;
    }

    public void start() throws MuleException {
        Collection<ExtensionModelLoader> extensionModelLoaders = this.extModelLoadersLookup.get();
        StringBuilder sb = new StringBuilder();
        extensionModelLoaders.stream().collect(Collectors.groupingBy(ExtensionModelLoader::getId)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            String classes = ((List)entry.getValue()).stream().map(extensionModelLoader -> extensionModelLoader.getClass().getName()).collect(Collectors.joining(", "));
            sb.append(System.lineSeparator()).append("ID [").append((String)entry.getKey()).append("] is being returned by the following classes [").append(classes).append("]");
        });
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There are several loaders that return the same identifier when looking up providers for '%s'. Full error list: %s", PROVIDER_CLASS.getName(), sb.toString())));
        }
        extensionModelLoaders.stream().forEach(extensionModelLoader -> this.extensionModelLoaders.put(extensionModelLoader.getId(), (ExtensionModelLoader)extensionModelLoader));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ExtensionModelLoader registered identifiers: {}", (Object)this.printExtensionModelLoaderIDs());
        }
    }

    public void stop() throws MuleException {
        this.extensionModelLoaders.clear();
    }

    @Override
    public Optional<ExtensionModelLoader> getExtensionModelLoader(LoaderDescriber loaderDescriber) {
        return this.extensionModelLoaders.containsKey(loaderDescriber.getId()) ? Optional.of(this.extensionModelLoaders.get(loaderDescriber.getId())) : Optional.empty();
    }

    private String printExtensionModelLoaderIDs() {
        return this.extensionModelLoaders.keySet().stream().collect(Collectors.joining(", "));
    }

    public String toString() {
        return String.format("%s[extensionModelLoaders=%s]", this.getClass().getName(), this.printExtensionModelLoaderIDs());
    }
}

