/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainClassLoaderFactory
implements DeployableArtifactClassLoaderFactory<DomainDescriptor> {
    protected static final Logger logger = LoggerFactory.getLogger(DomainClassLoaderFactory.class);
    private final ClassLoader containerClassLoader;
    private final NativeLibraryFinderFactory nativeLibraryFinderFactory;
    private Map<String, ArtifactClassLoader> domainArtifactClassLoaders = new HashMap<String, ArtifactClassLoader>();

    public DomainClassLoaderFactory(ClassLoader containerClassLoader, NativeLibraryFinderFactory nativeLibraryFinderFactory) {
        Preconditions.checkArgument((containerClassLoader != null ? 1 : 0) != 0, (String)"parentClassLoader cannot be null");
        Preconditions.checkArgument((nativeLibraryFinderFactory != null ? 1 : 0) != 0, (String)"nativeLibraryFinderFactory cannot be null");
        this.containerClassLoader = containerClassLoader;
        this.nativeLibraryFinderFactory = nativeLibraryFinderFactory;
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)domainName) ? 1 : 0) != 0, (String)"domainName cannot be empty");
        return "domain/" + domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, DomainDescriptor descriptor, List<ArtifactClassLoader> artifactClassLoaders) {
        String domainId = DomainClassLoaderFactory.getDomainId(descriptor.getName());
        ArtifactClassLoader domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
        if (domainClassLoader != null) {
            return domainClassLoader;
        }
        DomainClassLoaderFactory domainClassLoaderFactory = this;
        synchronized (domainClassLoaderFactory) {
            domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
            if (domainClassLoader == null) {
                if (descriptor.getName().equals("default")) {
                    domainClassLoader = this.getDefaultDomainClassLoader(parent, parent.getClassLoaderLookupPolicy());
                } else {
                    NativeLibraryFinder nativeLibraryFinder = this.nativeLibraryFinderFactory.create(descriptor.getDataFolderName(), descriptor.getLoadedNativeLibrariesFolderName(), descriptor.getClassLoaderModel().getUrls());
                    domainClassLoader = this.getCustomDomainClassLoader(parent, descriptor, artifactClassLoaders, nativeLibraryFinder);
                }
                domainClassLoader.addShutdownListener(() -> {
                    DomainClassLoaderFactory domainClassLoaderFactory = this;
                    synchronized (domainClassLoaderFactory) {
                        this.domainArtifactClassLoaders.remove(domainId);
                    }
                });
                this.domainArtifactClassLoaders.put(domainId, domainClassLoader);
            }
        }
        return domainClassLoader;
    }

    private ArtifactClassLoader getCustomDomainClassLoader(ArtifactClassLoader parent, DomainDescriptor domain, List<ArtifactClassLoader> artifactClassLoaders, NativeLibraryFinder nativeLibraryFinder) {
        this.validateDomain(domain);
        ClassLoaderLookupPolicy classLoaderLookupPolicy = this.getApplicationClassLoaderLookupPolicy(parent, domain);
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader(domain, parent.getClassLoader(), classLoaderLookupPolicy, Arrays.asList(domain.getClassLoaderModel().getUrls()), artifactClassLoaders, nativeLibraryFinder);
        return classLoader;
    }

    private ClassLoaderLookupPolicy getApplicationClassLoaderLookupPolicy(ArtifactClassLoader parent, DomainDescriptor descriptor) {
        HashMap pluginsLookupStrategies = new HashMap();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            artifactPluginDescriptor.getClassLoaderModel().getExportedPackages().forEach(p -> pluginsLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        return parent.getClassLoaderLookupPolicy().extend(pluginsLookupStrategies);
    }

    private ArtifactClassLoader getDefaultDomainClassLoader(ArtifactClassLoader parent, ClassLoaderLookupPolicy containerLookupPolicy) {
        return new MuleSharedDomainClassLoader(new DomainDescriptor("default"), parent.getClassLoader(), containerLookupPolicy.extend(Collections.emptyMap()), Collections.emptyList(), Collections.emptyList());
    }

    private void validateDomain(DomainDescriptor domainDescriptor) {
        File domainFolder = domainDescriptor.getRootFolder();
        if (!domainFolder.exists() || !domainFolder.isDirectory()) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Domain %s does not exists", domainDescriptor.getName())));
        }
    }
}

