/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.DependencyConverter;
import org.mule.runtime.module.deployment.impl.internal.maven.HeavyweightClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.LightweightClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedClassLoaderModelAttributes;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginMavenClassLoaderModelLoader
extends AbstractMavenClassLoaderModelLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String JAR = "jar";
    private static final String POM = "pom";

    public PluginMavenClassLoaderModelLoader(Optional<MavenClient> mavenClient) {
        super(mavenClient);
    }

    @Override
    protected org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel createLightPackageClassLoaderModel(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType, MavenClient mavenClient) {
        if (attributes instanceof PluginExtendedClassLoaderModelAttributes) {
            File muleArtifactJson;
            PluginExtendedClassLoaderModelAttributes pluginExtendedClassLoaderModelAttributes = (PluginExtendedClassLoaderModelAttributes)((Object)attributes);
            org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor pluginBundleDescriptor = (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginExtendedClassLoaderModelAttributes.get(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor.class.getName());
            File rootFolder = pluginExtendedClassLoaderModelAttributes.getDeployableArtifactDescriptor().getRootFolder();
            if (rootFolder != null && (muleArtifactJson = new File(rootFolder.getAbsolutePath(), this.getPathForMuleArtifactJson(pluginBundleDescriptor))).exists()) {
                return this.createHeavyPackageClassLoaderModel(artifactFile, muleArtifactJson, attributes, Optional.empty());
            }
        }
        return super.createLightPackageClassLoaderModel(artifactFile, attributes, artifactType, mavenClient);
    }

    private String getPathForMuleArtifactJson(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor pluginBundleDescriptor) {
        StringBuilder path = new StringBuilder(128);
        char slashChar = '/';
        path.append("META-INF").append(slashChar);
        path.append("mule-artifact").append(slashChar);
        path.append(pluginBundleDescriptor.getGroupId().replace('.', slashChar)).append(slashChar);
        path.append(pluginBundleDescriptor.getArtifactId()).append(slashChar);
        path.append(pluginBundleDescriptor.getBaseVersion()).append(slashChar);
        path.append("classloader-model.json");
        return path.toString();
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    protected List<URL> addArtifactSpecificClassloaderConfiguration(ArtifactClassLoaderModelBuilder classLoaderModelBuilder) {
        return classLoaderModelBuilder.includeAdditionalPluginDependencies();
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return artifactType.equals((Object)ArtifactType.PLUGIN);
    }

    @Override
    protected boolean includeProvidedDependencies(ArtifactType artifactType) {
        return false;
    }

    @Override
    protected File getClassLoaderModelDescriptor(File artifactFile) {
        return new File(artifactFile.getParent(), "classloader-model.json");
    }

    @Override
    protected LightweightClassLoaderModelBuilder newLightweightClassLoaderModelBuilder(File artifactFile, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactBundleDescriptor, MavenClient mavenClient, Map<String, Object> attributes, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> nonProvidedDependencies) {
        LightweightClassLoaderModelBuilder lightweightClassLoaderModelBuilder = new LightweightClassLoaderModelBuilder(artifactFile, artifactBundleDescriptor, mavenClient, nonProvidedDependencies);
        this.configClassLoaderModelBuilder(lightweightClassLoaderModelBuilder, attributes);
        return lightweightClassLoaderModelBuilder;
    }

    @Override
    protected HeavyweightClassLoaderModelBuilder newHeavyWeightClassLoaderModelBuilder(File artifactFile, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactBundleDescriptor, ClassLoaderModel packagerClassLoaderModel, Map<String, Object> attributes) {
        HeavyweightClassLoaderModelBuilder heavyweightClassLoaderModelBuilder = new HeavyweightClassLoaderModelBuilder(artifactFile, artifactBundleDescriptor, packagerClassLoaderModel);
        this.configClassLoaderModelBuilder(heavyweightClassLoaderModelBuilder, attributes);
        return heavyweightClassLoaderModelBuilder;
    }

    @Override
    protected List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> resolveArtifactDependencies(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType, MavenClient mavenClient) {
        if (attributes instanceof PluginExtendedClassLoaderModelAttributes) {
            org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor pluginBundleDescriptor = (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)attributes.get(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor.class.getName());
            ArtifactDescriptor deployableArtifactDescriptor = ((PluginExtendedClassLoaderModelAttributes)((Object)attributes)).getDeployableArtifactDescriptor();
            Set deployableArtifactDescriptorDependencies = deployableArtifactDescriptor.getClassLoaderModel().getDependencies();
            org.mule.runtime.module.artifact.api.descriptor.BundleDependency pluginDependencyInDeployableArtifact = deployableArtifactDescriptorDependencies.stream().filter(dep -> dep.getDescriptor().equals((Object)pluginBundleDescriptor)).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find required descriptor. Looking for: " + pluginBundleDescriptor + " in " + deployableArtifactDescriptorDependencies))));
            if (!BundleScope.SYSTEM.equals((Object)pluginDependencyInDeployableArtifact.getScope())) {
                return this.collectTransitiveDependencies(pluginDependencyInDeployableArtifact);
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(String.format("Resolving a mule-plugin '%s' with system scope in order to resolve its class loader model. Dependency resolution may fail due to remote repositories from the deployable artifact will not be considered. Prevent this by using compile scope instead", pluginDependencyInDeployableArtifact.getDescriptor()));
            }
        }
        return this.resolveArtifactDependenciesUsingMavenClient(artifactFile, mavenClient);
    }

    private List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> resolveArtifactDependenciesUsingMavenClient(File artifactFile, MavenClient mavenClient) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(String.format("Resolving a mule-plugin from '%s' without the deployable resolution context in order to resolve its class loader model. Dependency resolution may fail due to remote repositories from the deployable artifact will not be considered", artifactFile));
        }
        try (MuleSystemPluginMavenReactorResolver reactor = new MuleSystemPluginMavenReactorResolver(artifactFile, mavenClient);){
            Optional<File> mavenRepository = this.getLocalMavenRepo(artifactFile, mavenClient);
            BundleDescriptor mavenClientBundleDescriptor = new BundleDescriptor.Builder().setGroupId(reactor.getEffectiveModel().getGroupId()).setArtifactId(reactor.getEffectiveModel().getArtifactId()).setVersion(reactor.getEffectiveModel().getVersion()).setClassifier("mule-plugin").setType(JAR).build();
            List dependencies = mavenClient.resolveArtifactDependencies((List)ImmutableList.of((Object)mavenClientBundleDescriptor), mavenRepository, Optional.of(reactor));
            List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> list = this.collectTransitiveDependencies(new DependencyConverter().convert((BundleDependency)dependencies.get(0)));
            return list;
        }
    }

    private List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> collectTransitiveDependencies(org.mule.runtime.module.artifact.api.descriptor.BundleDependency rootDependency) {
        ArrayList<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> allTransitiveDependencies = new ArrayList<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>();
        for (org.mule.runtime.module.artifact.api.descriptor.BundleDependency transitiveDependency : rootDependency.getTransitiveDependenciesList()) {
            allTransitiveDependencies.add(transitiveDependency);
            if (!transitiveDependency.getDescriptor().getClassifier().map(c -> !"mule-plugin".equals(c)).orElse(true).booleanValue()) continue;
            allTransitiveDependencies.addAll(this.collectTransitiveDependencies(transitiveDependency));
        }
        return allTransitiveDependencies;
    }

    private void configClassLoaderModelBuilder(ArtifactClassLoaderModelBuilder classLoaderModelBuilder, Map<String, Object> attributes) {
        if (attributes instanceof PluginExtendedClassLoaderModelAttributes) {
            classLoaderModelBuilder.setDeployableArtifactDescriptor(((PluginExtendedClassLoaderModelAttributes)((Object)attributes)).getDeployableArtifactDescriptor());
        }
    }

    @Override
    protected ClassLoaderModel getPackagerClassLoaderModel(File classLoaderModelDescriptor) {
        return ClassLoaderModelJsonSerializer.deserialize((File)classLoaderModelDescriptor);
    }

    private class MuleSystemPluginMavenReactorResolver
    implements MavenReactorResolver,
    AutoCloseable {
        private final File temporaryFolder = Files.createTempDir();
        private final Model effectiveModel;
        private final File pomFile;
        private final File artifactFile;

        public MuleSystemPluginMavenReactorResolver(File artifactFile, MavenClient mavenClient) {
            this.effectiveModel = mavenClient.getEffectiveModel(artifactFile, Optional.of(this.temporaryFolder));
            this.pomFile = this.effectiveModel.getPomFile();
            this.artifactFile = artifactFile;
        }

        public Model getEffectiveModel() {
            return this.effectiveModel;
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals(PluginMavenClassLoaderModelLoader.POM)) {
                    return this.pomFile;
                }
                return this.artifactFile;
            }
            return null;
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return ImmutableList.of((Object)this.effectiveModel.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return this.effectiveModel.getGroupId().equals(bundleDescriptor.getGroupId()) && this.effectiveModel.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.effectiveModel.getVersion().equals(bundleDescriptor.getVersion());
        }

        @Override
        public void close() {
            FileUtils.deleteQuietly((File)this.temporaryFolder);
        }
    }
}

