/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentPropertiesUtils.class);
    private static final String DEPLOYMENT_PROPERTIES_FILE_NAME = "deployment.properties";
    private static final String FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME = "flows.deployment.properties";
    private static final String DEPLOYMENT_PROPERTIES_DIRECTORY = "deployment-properties";
    private static final String ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME = "artifact.status.deployment.properties";

    public static Properties resolveDeploymentProperties(String artifactName, Optional<Properties> deploymentProperties, String fileName) throws IOException {
        Properties properties = deploymentProperties.orElse(new Properties());
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, fileName);
        return properties;
    }

    public static Optional<Properties> getPersistedProperties(String artifactName, String fileName) {
        try {
            Path deploymentPropertiesPath = DeploymentPropertiesUtils.getDeploymentPropertiesPath(artifactName);
            return Optional.of(DeploymentPropertiesUtils.getDeploymentProperties(deploymentPropertiesPath, fileName));
        }
        catch (IOException e) {
            LOGGER.error("Failed to load persisted deployment property for artifact " + artifactName, (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<Properties> getPersistedDeploymentProperties(String artifactName) {
        return DeploymentPropertiesUtils.getPersistedProperties(artifactName, DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Optional<Properties> getPersistedFlowDeploymentProperties(String artifactName) {
        return DeploymentPropertiesUtils.getPersistedProperties(artifactName, FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Optional<Properties> getPersistedArtifactStatusDeploymentProperties(String artifactName) {
        return DeploymentPropertiesUtils.getPersistedProperties(artifactName, ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static void setPersistedProperties(String artifactName, Properties properties, String fileName) throws IOException {
        Path deploymentPropertiesPath = DeploymentPropertiesUtils.getDeploymentPropertiesPath(artifactName);
        DeploymentPropertiesUtils.initDeploymentPropertiesDirectory(deploymentPropertiesPath);
        DeploymentPropertiesUtils.persistDeploymentPropertiesFile(deploymentPropertiesPath, properties, fileName);
    }

    public static void setPersistedDeploymentProperties(String artifactName, Properties properties) throws IOException {
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static void setPersistedFlowDeploymentProperties(String artifactName, Properties properties) throws IOException {
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static void setPersistedArtifactStatusDeploymentProperties(String artifactName, Properties properties) throws IOException {
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    private static Path getDeploymentPropertiesPath(String artifactName) {
        return MuleFoldersUtil.getExecutionFolderPath().resolve(artifactName).resolve(DEPLOYMENT_PROPERTIES_DIRECTORY);
    }

    private static Properties getDeploymentProperties(Path deploymentPropertiesPath, String fileName) throws IOException {
        Path configFile = deploymentPropertiesPath.resolve(fileName);
        Properties props = new Properties();
        if (!Files.exists(configFile, new LinkOption[0])) {
            return props;
        }
        try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
            props.load(reader);
        }
        return props;
    }

    private static void initDeploymentPropertiesDirectory(Path deploymentPropertiesPath) throws IOException {
        if (!Files.exists(deploymentPropertiesPath, new LinkOption[0])) {
            DeploymentPropertiesUtils.createDeploymentPropertiesDirectory(deploymentPropertiesPath);
        }
    }

    private static synchronized void createDeploymentPropertiesDirectory(Path deploymentPropertiesDirectory) throws IOException {
        if (!Files.exists(deploymentPropertiesDirectory, new LinkOption[0])) {
            Files.createDirectories(deploymentPropertiesDirectory, new FileAttribute[0]);
        }
    }

    private static void persistDeploymentPropertiesFile(Path deploymentPropertiesPath, Properties deploymentProperties, String fileName) throws IOException {
        Path deploymentPropertiesFile = deploymentPropertiesPath.resolve(fileName);
        try (BufferedWriter fileWriter = Files.newBufferedWriter(deploymentPropertiesFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            deploymentProperties.store(fileWriter, "deployment properties");
        }
    }

    public static Properties resolveDeploymentProperties(String artifactName, Optional<Properties> deploymentProperties) throws IOException {
        return DeploymentPropertiesUtils.resolveDeploymentProperties(artifactName, deploymentProperties, DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Properties resolveFlowDeploymentProperties(String appName, Optional<Properties> deploymentProperties) throws IOException {
        return DeploymentPropertiesUtils.resolveDeploymentProperties(appName, deploymentProperties, FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Properties resolveArtifactStatusDeploymentProperties(String artifactName, Optional<Properties> statusProperties) throws IOException {
        return DeploymentPropertiesUtils.resolveDeploymentProperties(artifactName, statusProperties, ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }
}

