/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapService;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.internal.util.PropertiesUtils;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactBootstrapServiceDiscovererConfigurationBuilder
extends AbstractConfigurationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactBootstrapServiceDiscovererConfigurationBuilder.class);
    private final List<ArtifactPlugin> artifactPlugins;

    public ArtifactBootstrapServiceDiscovererConfigurationBuilder(List<ArtifactPlugin> artifactPlugins) {
        Objects.requireNonNull(artifactPlugins, "ArtifactPlugins cannot be null");
        this.artifactPlugins = artifactPlugins;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        PropertiesBootstrapServiceDiscoverer propertiesBootstrapServiceDiscoverer = new PropertiesBootstrapServiceDiscoverer(((Object)((Object)this)).getClass().getClassLoader());
        LinkedList<PropertiesBootstrapService> bootstrapServices = new LinkedList<PropertiesBootstrapService>();
        bootstrapServices.addAll(propertiesBootstrapServiceDiscoverer.discover());
        for (ArtifactPlugin artifactPlugin : this.artifactPlugins) {
            Enumeration resources = artifactPlugin.getArtifactClassLoader().findResources("META-INF/org/mule/runtime/core/config/registry-bootstrap.properties");
            while (resources.hasMoreElements()) {
                URL localResource = (URL)resources.nextElement();
                LOGGER.debug("Creating PropertiesBootstrapService from properties file: {}", (Object)localResource.toString());
                Properties properties = PropertiesUtils.loadProperties((URL)localResource);
                PropertiesBootstrapService pluginBootstrapService = new PropertiesBootstrapService(artifactPlugin.getArtifactClassLoader().getClassLoader(), properties);
                bootstrapServices.add(pluginBootstrapService);
            }
        }
        muleContext.setBootstrapServiceDiscoverer(() -> bootstrapServices);
    }
}

